/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.date.holidayenumerator;

import de.jaret.util.date.holidayenumerator.HolidayEnumeratorBase;
import java.util.Date;
import java.util.Locale;

public class HolidayEnumerator_de_DE
extends HolidayEnumeratorBase {
    public static final String DE_DE_REGION_NRW = "NRW";
    public static final String DE_DE_REGION_BLN = "BLN";
    public static final String DE_DE_REGION_BAV = "BAV";
    public static final String DE_DE_REGION_HH = "HH";
    public static final String DE_DE_REGION_HB = "HB";
    public static final String DE_DE_REGION_SHLST = "SHLST";
    public static final String DE_DE_REGION_NIE = "NIE";
    public static final String DE_DE_REGION_MVP = "MVP";
    public static final String DE_DE_REGION_BRA = "BRA";
    public static final String DE_DE_REGION_THUE = "THUE";
    public static final String DE_DE_REGION_SACH = "SACH";
    public static final String DE_DE_REGION_SAAN = "SAAN";
    public static final String DE_DE_REGION_BAWUE = "BAWUE";
    public static final String DE_DE_REGION_HES = "HES";
    public static final String DE_DE_REGION_SAAR = "SAAR";
    public static final String DE_DE_REGION_RHPFA = "RHPFA";
    private static final String[] REGIONIDS = new String[]{"NRW", "BLN", "BAV", "HH", "HB", "SHLST", "NIE", "MVP", "BRA", "THUE", "SACH", "SAAN", "BAWUE", "HES", "SAAR", "RHPFA"};

    public HolidayEnumerator_de_DE(String regionId) {
        this._regionId = regionId;
        this._locale = Locale.GERMANY;
    }

    public String[] getAvailableRegionIds() {
        return REGIONIDS;
    }

    protected void fillMap(int year) {
        this.addNamedDate(year, 0, 1, true, "Neujahr");
        this.addNamedDate(year, 4, 1, true, "Tag der Arbeit");
        this.addNamedDate(year, 9, 3, true, "Tag der deutschen Einheit");
        this.addNamedDate(year, 11, 24, false, "Heiligabend");
        this.addNamedDate(year, 11, 25, true, "1. Weihnachtsfeiertag");
        this.addNamedDate(year, 11, 26, true, "2. Weihnachtsfeiertag");
        this.addNamedDate(year, 11, 31, false, "Sylvester");
        HolidayEnumeratorBase.EasyDate ed = this.calcEaster(year);
        this.addNamedDate(year, ed.month, ed.day, true, "Ostersonntag");
        this.addNamedDate(year, ed.month, ed.day, 1, true, "Ostermontag");
        this.addNamedDate(year, ed.month, ed.day, -2, true, "Karfreitag");
        this.addNamedDate(year, ed.month, ed.day, 39, true, "Christi Himmelfahrt");
        this.addNamedDate(year, ed.month, ed.day, 49, true, "Pfingstsonntag");
        this.addNamedDate(year, ed.month, ed.day, 50, true, "Pfingstmontag");
        if (this._regionId != null && (this._regionId.equals(DE_DE_REGION_BAV) || this._regionId.equals(DE_DE_REGION_SAAN) || this._regionId.equals(DE_DE_REGION_BAWUE))) {
            this.addNamedDate(year, 0, 6, true, "Heilige drei K\u00f6nige");
        } else {
            this.addNamedDate(year, 0, 6, false, "Heilige drei K\u00f6nige");
        }
        if (this._regionId != null && (this._regionId.equals(DE_DE_REGION_BAV) || this._regionId.equals(DE_DE_REGION_BAWUE) || this._regionId.equals(DE_DE_REGION_HES) || this._regionId.equals(DE_DE_REGION_NRW) || this._regionId.equals(DE_DE_REGION_RHPFA) || this._regionId.equals(DE_DE_REGION_SAAR))) {
            this.addNamedDate(year, ed.month, ed.day, 60, true, "Fronleichnam");
        } else {
            this.addNamedDate(year, ed.month, ed.day, 60, false, "Fronleichnam");
        }
        if (this._regionId != null && this._regionId.equals(DE_DE_REGION_SAAR)) {
            this.addNamedDate(year, 7, 15, true, "Mari\u00e4 Himmelfahrt");
        } else {
            this.addNamedDate(year, 7, 15, false, "Mari\u00e4 Himmelfahrt");
        }
        if (this._regionId != null && (this._regionId.equals(DE_DE_REGION_BRA) || this._regionId.equals(DE_DE_REGION_MVP) || this._regionId.equals(DE_DE_REGION_SACH) || this._regionId.equals(DE_DE_REGION_SAAN) || this._regionId.equals(DE_DE_REGION_THUE))) {
            this.addNamedDate(year, 9, 31, true, "Reformationstag");
        } else {
            this.addNamedDate(year, 9, 31, false, "Reformationstag");
        }
        if (this._regionId != null && (this._regionId.equals(DE_DE_REGION_BAV) || this._regionId.equals(DE_DE_REGION_BAWUE) || this._regionId.equals(DE_DE_REGION_NRW) || this._regionId.equals(DE_DE_REGION_RHPFA) || this._regionId.equals(DE_DE_REGION_SAAR))) {
            this.addNamedDate(year, 10, 1, true, "Allerheiligen");
        } else {
            this.addNamedDate(year, 10, 1, false, "Allerheiligen");
        }
        HolidayEnumeratorBase.EasyDate bbt = this.calcBussBettag(year);
        if (this._regionId != null && this._regionId.equals(DE_DE_REGION_SACH)) {
            this.addNamedDate(year, bbt.month, bbt.day, true, "Bu\u00df- und Bettag");
        } else {
            this.addNamedDate(year, bbt.month, bbt.day, false, "Bu\u00df- und Bettag");
        }
        this.addNamedDate(year, ed.month, ed.day, -48, false, "Rosenmontag");
        this.addNamedDate(year, ed.month, ed.day, -52, false, "Weiberfastnacht");
    }

    protected HolidayEnumeratorBase.EasyDate calcBussBettag(int year) {
        HolidayEnumeratorBase.EasyDate result = null;
        for (int i = 0; i < 7 && result == null; ++i) {
            Date d = this.getDate(year, 10, 16, i);
            if (this.getWeekday(d) != 4) continue;
            result = new HolidayEnumeratorBase.EasyDate(d);
        }
        return result;
    }
}

