/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.date.holidayenumerator;

import de.jaret.util.date.holidayenumerator.HolidayEnumeratorBase;
import java.util.Locale;

public class HolidayEnumerator_fr_FR
extends HolidayEnumeratorBase {
    public static final String REGION_CENTRAL = "CEN";
    public static final String REGION_ALSACE = "ALS";
    public static final String REGION_MOSELLE = "MOS";
    private static final String[] REGIONIDS = new String[]{"CEN", "ALS", "MOS"};

    public HolidayEnumerator_fr_FR(String regionId) {
        this._regionId = regionId;
        this._locale = Locale.FRANCE;
    }

    public String[] getAvailableRegionIds() {
        return REGIONIDS;
    }

    protected void fillMap(int year) {
        this.addNamedDate(year, 0, 1, true, "Jour de l'an");
        this.addNamedDate(year, 4, 1, true, "F\u00ef\u00bf\u00bdte du Travail");
        this.addNamedDate(year, 4, 8, true, "Victoire de 1945");
        this.addNamedDate(year, 6, 14, true, "F\u00ef\u00bf\u00bdte nationale");
        this.addNamedDate(year, 7, 15, true, "Assomption");
        this.addNamedDate(year, 10, 1, true, "La toussaint");
        this.addNamedDate(year, 10, 11, true, "Armistice 1918");
        this.addNamedDate(year, 11, 25, true, "No\u00ef\u00bf\u00bdl");
        if (this._regionId != null && (this._regionId.equals(REGION_ALSACE) || this._regionId.equals(REGION_MOSELLE))) {
            this.addNamedDate(year, 11, 26, true, "Saint \u00ef\u00bf\u00bdtienne");
        } else {
            this.addNamedDate(year, 11, 26, false, "Saint \u00ef\u00bf\u00bdtienne");
        }
        HolidayEnumeratorBase.EasyDate ed = this.calcEaster(year);
        this.addNamedDate(year, ed.month, ed.day, true, "P\u00ef\u00bf\u00bdques");
        this.addNamedDate(year, ed.month, ed.day, 1, true, "Lundi de P\u00ef\u00bf\u00bdques");
        if (this._regionId != null && (this._regionId.equals(REGION_ALSACE) || this._regionId.equals(REGION_MOSELLE))) {
            this.addNamedDate(year, ed.month, ed.day, -2, true, "Vendredi saint");
        } else {
            this.addNamedDate(year, ed.month, ed.day, -2, false, "Vendredi saint");
        }
        this.addNamedDate(year, ed.month, ed.day, 39, true, "Ascension");
        this.addNamedDate(year, ed.month, ed.day, 49, true, "Pentec\u00ef\u00bf\u00bdte");
    }
}

