/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.date.iterator;

import de.jaret.util.date.JaretDate;
import de.jaret.util.date.iterator.DateIterator;

public abstract class AbstractDateIterator
implements DateIterator {
    protected JaretDate _currentDate;
    protected JaretDate _endDate;
    protected JaretDate _nextDate;

    public AbstractDateIterator(JaretDate startDate, JaretDate endDate) {
        this.reInitialize(startDate, endDate);
    }

    public AbstractDateIterator() {
    }

    protected abstract JaretDate correctStartDate(JaretDate var1);

    protected abstract void advanceDate(JaretDate var1);

    protected abstract String getLabel(JaretDate var1, JaretDate var2, DateIterator.Format var3);

    public void reInitialize(JaretDate startDate, JaretDate endDate) {
        this._currentDate = startDate.copy();
        this._currentDate = this.correctStartDate(this._currentDate);
        this._endDate = endDate == null ? null : endDate.copy();
        this._nextDate = this.internalNextDate();
    }

    private JaretDate internalNextDate() {
        if (this._currentDate == null) {
            return null;
        }
        JaretDate d = this._currentDate.copy();
        this.advanceDate(d);
        if (this._endDate == null || d.compareDateTo(this._endDate) <= 0) {
            return d;
        }
        return null;
    }

    public JaretDate getNextDate() {
        if (this._currentDate == null) {
            throw new IllegalStateException("not initialized");
        }
        JaretDate result = this._currentDate;
        this._currentDate = this.internalNextDate();
        this._nextDate = this.internalNextDate();
        return result;
    }

    public boolean hasNextDate() {
        return this._currentDate != null;
    }

    public JaretDate previewNextDate() {
        if (this._currentDate == null) {
            throw new IllegalStateException("not initialized");
        }
        return this._nextDate;
    }

    public String getLabel(DateIterator.Format format) {
        if (this._currentDate == null) {
            throw new IllegalStateException("not initialized");
        }
        return this.getLabel(this._currentDate, this._nextDate, format);
    }
}

