/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.date.iterator;

import de.jaret.util.date.JaretDate;
import de.jaret.util.date.iterator.AbstractDateIterator;
import de.jaret.util.date.iterator.DateIterator;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class HourIterator
extends AbstractDateIterator
implements DateIterator {
    private static final int DEFAULT_STEP = 12;
    protected int _hourStep = 12;
    protected static final NumberFormat NF = new DecimalFormat();

    public HourIterator(int hourStep) {
        this._hourStep = hourStep;
    }

    protected void advanceDate(JaretDate date) {
        date.advanceHours(this._hourStep);
    }

    public int getApproxStepSeconds() {
        return this._hourStep * 60 * 60;
    }

    protected JaretDate correctStartDate(JaretDate date) {
        date.setMinutes(0);
        date.setSeconds(0);
        date.setMilliseconds(0);
        int diff = date.getHours() % this._hourStep;
        date.backHours(diff);
        return date;
    }

    protected String getLabel(JaretDate date, JaretDate nextDate, DateIterator.Format format) {
        if (format.equals((Object)DateIterator.Format.SHORT)) {
            return date.getHours() + "h";
        }
        if (format.equals((Object)DateIterator.Format.MEDIUM)) {
            return NF.format(date.getHours()) + ":" + NF.format(date.getMinutes());
        }
        return NF.format(date.getHours()) + ":" + NF.format(date.getMinutes());
    }

    static {
        NF.setMaximumFractionDigits(0);
        NF.setMinimumIntegerDigits(2);
    }
}

