/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.date.iterator;

import de.jaret.util.date.JaretDate;
import de.jaret.util.date.iterator.AbstractDateIterator;
import de.jaret.util.date.iterator.DateIterator;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class MinuteIterator
extends AbstractDateIterator
implements DateIterator {
    private static final int DEFAULT_STEP = 30;
    protected int _minuteStep = 30;
    protected static final NumberFormat NF = new DecimalFormat();

    public MinuteIterator(int minuteStep) {
        this._minuteStep = minuteStep;
    }

    protected void advanceDate(JaretDate date) {
        date.advanceMinutes(this._minuteStep);
    }

    public int getApproxStepSeconds() {
        return this._minuteStep * 60;
    }

    protected JaretDate correctStartDate(JaretDate date) {
        date.setSeconds(0);
        date.setMilliseconds(0);
        int diff = date.getMinutes() % this._minuteStep;
        date.backMinutes(diff);
        return date;
    }

    protected String getLabel(JaretDate date, JaretDate nextDate, DateIterator.Format format) {
        if (format.equals((Object)DateIterator.Format.SHORT)) {
            return date.getMinutes() + "'";
        }
        if (format.equals((Object)DateIterator.Format.MEDIUM)) {
            return NF.format(date.getHours()) + ":" + NF.format(date.getMinutes());
        }
        return NF.format(date.getHours()) + ":" + NF.format(date.getMinutes()) + ":" + NF.format(date.getSeconds());
    }

    static {
        NF.setMaximumFractionDigits(0);
        NF.setMinimumIntegerDigits(2);
    }
}

