/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.date.iterator;

import de.jaret.util.date.JaretDate;
import de.jaret.util.date.iterator.AbstractDateIterator;
import de.jaret.util.date.iterator.DateIterator;
import java.util.GregorianCalendar;

public class WeekIterator
extends AbstractDateIterator
implements DateIterator {
    private static final int DAYSINWEEK = 7;

    protected void advanceDate(JaretDate date) {
        date.advanceDays(7);
    }

    public int getApproxStepSeconds() {
        return 604800;
    }

    protected JaretDate correctStartDate(JaretDate date) {
        date.setTime(0, 0, 0);
        GregorianCalendar cal = new GregorianCalendar();
        int firstDayInWeek = cal.getFirstDayOfWeek();
        while (date.getDayOfWeek() != firstDayInWeek) {
            date.backDays(1.0);
        }
        return date;
    }

    protected String getLabel(JaretDate date, JaretDate nextDate, DateIterator.Format format) {
        if (format.equals((Object)DateIterator.Format.SHORT)) {
            return Integer.toString(date.getWeekOfYear()) + ".";
        }
        if (format.equals((Object)DateIterator.Format.MEDIUM)) {
            return Integer.toString(date.getWeekOfYear()) + ".(" + date.toDisplayStringDate() + ")";
        }
        return Integer.toString(date.getWeekOfYear()) + ". (" + date.toDisplayStringDate() + (nextDate != null ? "-" + nextDate.toDisplayStringDate() : "") + ")";
    }
}

