/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.misc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MiscUtil {
    public static String getFilename(String path) {
        int idx = path.lastIndexOf("\\");
        if (idx == -1) {
            idx = path.lastIndexOf("/");
        }
        if (idx == -1) {
            return path;
        }
        return path.substring(idx + 1);
    }

    public static String getPath(String path) {
        int idx = path.lastIndexOf("\\");
        if (idx == -1) {
            idx = path.lastIndexOf("/");
        }
        if (idx == -1) {
            return path;
        }
        return path.substring(0, idx);
    }

    public static StringBuffer readTextFile(String completePath) {
        StringBuffer buf = new StringBuffer();
        File file = new File(completePath);
        try {
            FileReader fr = new FileReader(file);
            char[] buffer = new char[1024];
            int read = 1;
            while (read > 0) {
                read = fr.read(buffer);
                if (read <= 0) continue;
                buf.append(buffer, 0, read);
            }
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("File could not be read " + completePath + " " + e.getLocalizedMessage());
        }
        return buf;
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileInputStream src = new FileInputStream(srcFile);
        FileOutputStream dest = new FileOutputStream(destFile);
        byte[] buffer = new byte[1024];
        int read = 1;
        while (read > 0) {
            read = ((InputStream)src).read(buffer);
            if (read <= 0) continue;
            ((OutputStream)dest).write(buffer, 0, read);
        }
        ((InputStream)src).close();
        ((OutputStream)dest).close();
    }

    public static String leftTrim(String str) {
        char c;
        int i;
        if (str.length() == 0) {
            return str;
        }
        for (i = 0; i < str.length() && Character.isWhitespace(c = str.charAt(i)); ++i) {
        }
        return str.substring(i);
    }

    public static String rightTrim(String str) {
        char c;
        int i;
        if (str.length() == 0) {
            return str;
        }
        for (i = str.length() - 1; i >= 0 && Character.isWhitespace(c = str.charAt(i)); --i) {
        }
        return str.substring(0, i + 1);
    }
}

