/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.swing;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class GraphicsHelper {
    public static void drawStringCentered(Graphics graphics, String string, int left, int right, int y) {
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(string, graphics);
        int width = right - left;
        int xx = (int)(((double)width - rect.getWidth()) / 2.0);
        graphics.drawString(string, xx, y);
    }

    public static void drawStringCenteredVCenter(Graphics graphics, String string, int left, int right, int yCenter) {
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(string, graphics);
        int descent = graphics.getFontMetrics().getDescent();
        int width = right - left;
        int xx = (int)(((double)width - rect.getWidth()) / 2.0);
        int y = yCenter + (int)(rect.getHeight() / 2.0 - (double)descent);
        graphics.drawString(string, xx, y);
    }

    public static void drawStringRightAlignedVCenter(Graphics graphics, String string, int x, int y) {
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(string, graphics);
        int xx = (int)((double)x - rect.getWidth());
        int yy = (int)((double)y + rect.getHeight() / 2.0);
        graphics.drawString(string, xx, yy);
    }

    public static void drawStringLeftAlignedVCenter(Graphics graphics, String string, int x, int y) {
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(string, graphics);
        int xx = x;
        int yy = (int)((double)y + rect.getHeight() / 2.0);
        graphics.drawString(string, xx, yy);
    }

    public static void drawStringCentered(Graphics graphics, String string, int x, int y) {
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(string, graphics);
        int xx = x - (int)(rect.getWidth() / 2.0);
        graphics.drawString(string, xx, y);
    }

    public static void drawStringCenteredPoint(Graphics graphics, String string, int x, int y) {
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(string, graphics);
        int xx = x - (int)(rect.getWidth() / 2.0);
        int yy = (int)((double)y + rect.getHeight() / 2.0);
        graphics.drawString(string, xx, yy);
    }

    public static void drawStringCentered(Graphics graphics, String string, Rectangle area) {
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(string, graphics);
        int xx = area.x + area.width / 2 - (int)(rect.getWidth() / 2.0);
        int yy = (int)((double)(area.y + area.height / 2) + rect.getHeight() / 2.0);
        graphics.drawString(string, xx, yy);
    }

    public static int getStringDrawingWidth(Graphics graphics, String string) {
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(string, graphics);
        return (int)rect.getWidth();
    }

    public static int getStringDrawingHeight(Graphics graphics, String string) {
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(string, graphics);
        return (int)rect.getHeight() - graphics.getFontMetrics().getDescent();
    }

    public static void drawStringRightAlignedVTop(Graphics graphics, String string, int x, int yTop) {
        Rectangle2D rect = graphics.getFontMetrics().getStringBounds(string, graphics);
        int xx = (int)((double)x - rect.getWidth());
        int yy = (int)((double)yTop + rect.getHeight());
        graphics.drawString(string, xx, yy);
    }

    public static void drawArrowLine(Graphics g, int x1, int y1, int x2, int y2, int dist, boolean arrowLeft, boolean arrowRight) {
        int off = 3;
        g.drawLine(x1 + off + 1, y1, x2 - off - 1, y2);
        if (arrowLeft) {
            g.drawLine(x1, y1, x1 + dist, y1 - off);
            g.drawLine(x1, y1, x1 + dist, y1 + off);
            g.drawLine(x1 + dist, y1 - off, x1 + dist, y1 + off);
        }
        if (arrowRight) {
            g.drawLine(x2, y2, x2 - dist, y2 - off);
            g.drawLine(x2, y2, x2 - dist, y2 + off);
            g.drawLine(x2 - dist, y2 - off, x2 - dist, y2 + off);
        }
    }

    public static void drawArrowLineVertical(Graphics g, int x1, int y1, int x2, int y2, int dist, int height, boolean arrowUp, boolean arrowDown) {
        int off = height;
        g.drawLine(x1, y1 + off + 1, x2, y2 - off - 1);
        if (arrowUp) {
            g.drawLine(x1, y1, x1 - off, y1 + dist);
            g.drawLine(x1, y1, x1 + off, y1 + dist);
            g.drawLine(x1 - off, y1 + dist, x1 + off, y1 + dist);
        }
        if (arrowDown) {
            g.drawLine(x2, y2, x2 - off, y2 - dist);
            g.drawLine(x2, y2, x2 + off, y2 - dist);
            g.drawLine(x2 - off, y2 - dist, x2 + off, y2 - dist);
        }
    }
}

