/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager {
    protected static Map<Device, ColorManager> _instances = new HashMap<Device, ColorManager>();
    protected Map<RGB, Color> _colorTable = new HashMap<RGB, Color>(10);
    protected Device _device;

    public ColorManager(Device device) {
        this._device = device != null ? device : Display.getCurrent();
    }

    public static ColorManager getColorManager(Device device) {
        ColorManager cm = _instances.get(device);
        if (cm == null) {
            cm = new ColorManager(device);
            _instances.put(device, cm);
        }
        return cm;
    }

    public static void disposeAll() {
        for (Device device : _instances.keySet()) {
            ColorManager cm = ColorManager.getColorManager(device);
            cm.dispose();
        }
        _instances.clear();
    }

    public void dispose() {
        for (Color color : this._colorTable.values()) {
            color.dispose();
        }
    }

    public Color getColor(RGB rgb) {
        Color color = this._colorTable.get(rgb);
        if (color == null) {
            color = new Color(this._device, rgb);
            this._colorTable.put(rgb, color);
        }
        return color;
    }
}

