/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class FontManager {
    protected static Map<Device, FontManager> _instances = new HashMap<Device, FontManager>();
    protected Map<FontData, Font> _fontTable = new HashMap<FontData, Font>(10);
    protected Device _device;

    public FontManager(Device device) {
        this._device = device != null ? device : Display.getCurrent();
    }

    public static FontManager getFontManager(Device device) {
        FontManager cm = _instances.get(device);
        if (cm == null) {
            cm = new FontManager(device);
            _instances.put(device, cm);
        }
        return cm;
    }

    public static void disposeAll() {
        for (Device device : _instances.keySet()) {
            FontManager cm = FontManager.getFontManager(device);
            cm.dispose();
        }
        _instances.clear();
    }

    public void dispose() {
        for (Font Font2 : this._fontTable.values()) {
            Font2.dispose();
        }
    }

    public Font getFont(FontData FontData2) {
        Font Font2 = this._fontTable.get(FontData2);
        if (Font2 == null) {
            Font2 = new Font(this._device, FontData2);
            this._fontTable.put(FontData2, Font2);
        }
        return Font2;
    }
}

