/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.swt;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;

public class SwtGraphicsHelper {
    public static void drawStringCentered(GC gc, String string, int left, int right, int y) {
        Point extent = gc.textExtent(string);
        int width = right - left;
        int xx = (width - extent.x) / 2;
        gc.drawString(string, left + xx, y);
    }

    public static void drawStringCenteredMidX(GC gc, String string, int midx, int y) {
        Point extent = gc.textExtent(string);
        int xx = midx - extent.x / 2;
        gc.drawString(string, xx, y);
    }

    public static void drawStringCenteredVCenter(GC gc, String string, int left, int right, int yCenter) {
        Point extent = gc.textExtent(string);
        int descent = 0;
        int width = right - left;
        int xx = (width - extent.x) / 2;
        int y = yCenter - (extent.y / 2 - descent);
        gc.drawString(string, left + xx, y);
    }

    public static void drawStringRightAlignedVCenter(GC gc, String string, int x, int y) {
        Point extent = gc.textExtent(string);
        int xx = x - extent.x;
        int yy = y - extent.y / 2;
        gc.drawString(string, xx, yy);
    }

    public static void drawStringLeftAlignedVCenter(GC gc, String string, int x, int y) {
        Point extent = gc.textExtent(string);
        int xx = x;
        int yy = y - extent.y / 2;
        gc.drawString(string, xx, yy);
    }

    public static void drawStringCentered(GC gc, String string, int xCenter, int yBase) {
        Point extent = gc.textExtent(string);
        int xx = xCenter - extent.x / 2;
        gc.drawText(string, xx, yBase - extent.y, true);
    }

    public static void drawStringCenteredAroundPoint(GC gc, String string, int xCenter, int yCenter) {
        Point extent = gc.textExtent(string);
        int xx = xCenter - extent.x / 2;
        int yy = yCenter - extent.y / 2;
        gc.drawText(string, xx, yy, true);
    }

    public static void drawStringCentered(GC gc, String string, int x, int y, int width, int height) {
        Point extent = gc.textExtent(string);
        int xx = x + (width - extent.x) / 2;
        int yy = y + (height - extent.y) / 2;
        gc.drawText(string, xx, yy, true);
    }

    public static void drawStringCentered(GC gc, String string, Rectangle rect) {
        SwtGraphicsHelper.drawStringCentered(gc, string, rect.x, rect.y, rect.width, rect.height);
    }

    public static int getStringDrawingWidth(GC gc, String string) {
        return gc.textExtent((String)string).x;
    }

    public static int getStringDrawingHeight(GC gc, String string) {
        return gc.textExtent((String)string).y;
    }

    public static void drawStringRightAlignedVTop(GC gc, String string, int x, int yTop) {
        Point extent = gc.textExtent(string);
        int xx = x - extent.x;
        gc.drawText(string, xx, yTop, true);
    }

    public static void drawArrowLine(GC gc, int x1, int y1, int x2, int y2, int dist, int height, boolean arrowLeft, boolean arrowRight) {
        int off = height;
        gc.drawLine(x1 + off + 1, y1, x2 - off - 1, y2);
        if (arrowLeft) {
            gc.drawLine(x1, y1, x1 + dist, y1 - off);
            gc.drawLine(x1, y1, x1 + dist, y1 + off);
            gc.drawLine(x1 + dist, y1 - off, x1 + dist, y1 + off);
        }
        if (arrowRight) {
            gc.drawLine(x2, y2, x2 - dist, y2 - off);
            gc.drawLine(x2, y2, x2 - dist, y2 + off);
            gc.drawLine(x2 - dist, y2 - off, x2 - dist, y2 + off);
        }
    }

    public static void drawArrowLineVertical(GC gc, int x1, int y1, int x2, int y2, int dist, int height, boolean arrowUp, boolean arrowDown) {
        int off = height;
        gc.drawLine(x1, y1 + off + 1, x2, y2 - off - 1);
        if (arrowUp) {
            gc.drawLine(x1, y1, x1 - off, y1 + dist);
            gc.drawLine(x1, y1, x1 + off, y1 + dist);
            gc.drawLine(x1 - off, y1 + dist, x1 + off, y1 + dist);
        }
        if (arrowDown) {
            gc.drawLine(x2, y2, x2 - off, y2 - dist);
            gc.drawLine(x2, y2, x2 + off, y2 - dist);
            gc.drawLine(x2 - off, y2 - dist, x2 + off, y2 - dist);
        }
    }

    public static void drawStringVCentered(GC gc, String label, int x, int upperY, int lowerY) {
        Point extent = gc.textExtent(label);
        int yy = upperY + (lowerY - upperY - extent.y) / 2;
        gc.drawText(label, x, yy, true);
    }

    public static void drawStringVertical(GC gc, String string, int x, int y) {
        Point extent = gc.textExtent(string);
        Image img = new Image(gc.getDevice(), extent.x, extent.y);
        GC imageGC = new GC((Drawable)img);
        imageGC.drawString(string, 0, 0);
        imageGC.dispose();
        Image vertImg = new Image(gc.getDevice(), extent.y, extent.x);
        ImageData iData = img.getImageData();
        ImageData destIData = vertImg.getImageData();
        for (int xx = 0; xx < iData.width; ++xx) {
            for (int yy = 0; yy < iData.height; ++yy) {
                destIData.setPixel(yy, iData.width - xx - 1, iData.getPixel(xx, yy));
            }
        }
        img.dispose();
        Image destImg = new Image(gc.getDevice(), destIData);
        gc.drawImage(destImg, x, y);
        vertImg.dispose();
        destImg.dispose();
    }

    public static ImageData dropShadow(ImageData originalImageData, Color color, int radius, int highlightRadius, int opacity) {
        double highlightRadiusIncrease;
        if (originalImageData == null) {
            return null;
        }
        if (color == null) {
            return null;
        }
        if (radius == 0) {
            return originalImageData;
        }
        int shift = (int)((double)radius * 1.5);
        double d = radius < highlightRadius * 2 ? 0.15 : (highlightRadiusIncrease = radius < highlightRadius * 3 ? 0.09 : 0.02);
        opacity = opacity > 255 ? 255 : (opacity < 0 ? 0 : opacity);
        ImageData newImageData = new ImageData(originalImageData.width + radius * 2, originalImageData.height + radius * 2, 24, new PaletteData(255, 65280, 0xFF0000));
        int[] pixels = new int[originalImageData.width];
        for (int row = radius; row < radius + originalImageData.height; ++row) {
            originalImageData.getPixels(0, row - radius, originalImageData.width, pixels, 0);
            for (int col = 0; col < pixels.length; ++col) {
                pixels[col] = newImageData.palette.getPixel(originalImageData.palette.getRGB(pixels[col]));
            }
            newImageData.setPixels(radius, row, originalImageData.width, pixels, 0);
        }
        int colorInt = newImageData.palette.getPixel(color.getRGB());
        pixels = new int[newImageData.width];
        for (int i = 0; i < newImageData.width; ++i) {
            pixels[i] = colorInt;
        }
        byte[] alphas = new byte[newImageData.width];
        for (int row = 0; row < newImageData.height; ++row) {
            if (row < radius) {
                byte intensity = (byte)((double)opacity * ((double)(row + 1) / (double)radius));
                for (int col = 0; col < alphas.length / 2 + alphas.length % 2; ++col) {
                    if (col < radius) {
                        double hypotenuse = Math.sqrt(Math.pow(radius - col - 1, 2.0) + Math.pow(radius - 1 - row, 2.0));
                        byte by = (byte)((double)opacity * Math.max(((double)radius - hypotenuse) / (double)radius, 0.0));
                        alphas[alphas.length - col - 1] = by;
                        alphas[col + shift] = by;
                        if (!(hypotenuse < Math.min((double)highlightRadius, (double)radius * 0.5))) continue;
                        byte by2 = (byte)Math.min(255.0, (double)(alphas[col + shift] & 0xFF) * (1.0 + highlightRadiusIncrease * Math.max(((double)radius - hypotenuse) / (double)radius, 0.0)));
                        alphas[alphas.length - col - 1] = by2;
                        alphas[col + shift] = by2;
                        continue;
                    }
                    byte by = (byte)((double)row > Math.max((double)(radius - highlightRadius - 1), (double)radius * 0.5) ? Math.min(255.0, (double)(intensity & 0xFF) * (1.0 + highlightRadiusIncrease * (double)row / (double)radius)) : (double)intensity);
                    alphas[alphas.length - col - 1] = by;
                    alphas[col + shift] = by;
                }
                if (row + shift < newImageData.height) {
                    newImageData.setAlphas(newImageData.width - radius, row + shift, radius, alphas, alphas.length - radius);
                    newImageData.setPixels(newImageData.width - radius, row + shift, radius, pixels, alphas.length - radius);
                }
                newImageData.setAlphas(0, newImageData.height - 1 - row, newImageData.width, alphas, 0);
                newImageData.setPixels(0, newImageData.height - 1 - row, newImageData.width, pixels, 0);
                continue;
            }
            if (row > newImageData.height / 2) continue;
            double intensity = 0.0;
            for (int col = 0; col < alphas.length; ++col) {
                if (col < radius) {
                    intensity = (double)opacity * ((double)(col + 1) / (double)radius);
                    if ((double)col > Math.max((double)(radius - highlightRadius - 1), (double)radius * 0.5)) {
                        intensity = Math.min(255.0, intensity * (1.0 + highlightRadiusIncrease * (double)col / (double)radius));
                    }
                    alphas[newImageData.width - col - 1] = (byte)intensity;
                    alphas[col] = 0;
                    continue;
                }
                if (col > newImageData.width / 2 + newImageData.width % 2) continue;
                alphas[newImageData.width - col - 1] = -1;
                alphas[col] = -1;
            }
            newImageData.setPixels(0, newImageData.height - 1 - row, radius, pixels, 0);
            newImageData.setPixels(originalImageData.width + radius, newImageData.height - 1 - row, radius, pixels, 0);
            newImageData.setAlphas(0, newImageData.height - 1 - row, newImageData.width, alphas, 0);
            if (row >= shift + radius) {
                newImageData.setPixels(0, row, radius, pixels, 0);
                newImageData.setPixels(originalImageData.width + radius, row, radius, pixels, 0);
                newImageData.setAlphas(0, row, newImageData.width, alphas, 0);
                continue;
            }
            newImageData.setPixels(0, row, radius, pixels, 0);
            newImageData.setAlphas(0, row, newImageData.width - radius, alphas, 0);
        }
        return newImageData;
    }

    public static ImageData glow(ImageData originalImageData, Color color, int radius, int highlightRadius, int opacity) {
        double highlightRadiusIncrease;
        if (originalImageData == null) {
            return null;
        }
        if (color == null) {
            return null;
        }
        if (radius == 0) {
            return originalImageData;
        }
        double d = radius < highlightRadius * 2 ? 0.15 : (highlightRadiusIncrease = radius < highlightRadius * 3 ? 0.09 : 0.02);
        opacity = opacity > 255 ? 255 : (opacity < 0 ? 0 : opacity);
        ImageData newImageData = new ImageData(originalImageData.width + radius * 2, originalImageData.height + radius * 2, 24, new PaletteData(255, 65280, 0xFF0000));
        int[] pixels = new int[originalImageData.width];
        for (int row = radius; row < radius + originalImageData.height; ++row) {
            originalImageData.getPixels(0, row - radius, originalImageData.width, pixels, 0);
            for (int col = 0; col < pixels.length; ++col) {
                pixels[col] = newImageData.palette.getPixel(originalImageData.palette.getRGB(pixels[col]));
            }
            newImageData.setPixels(radius, row, originalImageData.width, pixels, 0);
        }
        int colorInt = newImageData.palette.getPixel(color.getRGB());
        pixels = new int[newImageData.width];
        for (int i = 0; i < newImageData.width; ++i) {
            pixels[i] = colorInt;
        }
        byte[] alphas = new byte[newImageData.width];
        for (int row = 0; row < newImageData.height; ++row) {
            if (row < radius) {
                byte intensity = (byte)((double)opacity * ((double)(row + 1) / (double)radius));
                for (int col = 0; col < alphas.length / 2 + alphas.length % 2; ++col) {
                    if (col < radius) {
                        double hypotenuse = Math.sqrt(Math.pow(radius - col - 1, 2.0) + Math.pow(radius - 1 - row, 2.0));
                        byte by = (byte)((double)opacity * Math.max(((double)radius - hypotenuse) / (double)radius, 0.0));
                        alphas[alphas.length - col - 1] = by;
                        alphas[col] = by;
                        if (!(hypotenuse < Math.min((double)highlightRadius, (double)radius * 0.5))) continue;
                        byte by2 = (byte)Math.min(255.0, (double)(alphas[col] & 0xFF) * (1.0 + highlightRadiusIncrease * Math.max(((double)radius - hypotenuse) / (double)radius, 0.0)));
                        alphas[alphas.length - col - 1] = by2;
                        alphas[col] = by2;
                        continue;
                    }
                    byte by = (byte)((double)row > Math.max((double)(radius - highlightRadius - 1), (double)radius * 0.5) ? Math.min(255.0, (double)(intensity & 0xFF) * (1.0 + highlightRadiusIncrease * (double)row / (double)radius)) : (double)intensity);
                    alphas[alphas.length - 1 - col] = by;
                    alphas[col] = by;
                }
                newImageData.setAlphas(0, row, newImageData.width, alphas, 0);
                newImageData.setAlphas(0, newImageData.height - 1 - row, newImageData.width, alphas, 0);
                newImageData.setPixels(0, row, newImageData.width, pixels, 0);
                newImageData.setPixels(0, newImageData.height - 1 - row, newImageData.width, pixels, 0);
                continue;
            }
            if (row > newImageData.height / 2) continue;
            double intensity = 0.0;
            for (int col = 0; col < alphas.length; ++col) {
                if (col < radius) {
                    intensity = (double)opacity * ((double)(col + 1) / (double)radius);
                    if ((double)col > Math.max((double)(radius - highlightRadius - 1), (double)radius * 0.5)) {
                        intensity = Math.min(255.0, intensity * (1.0 + highlightRadiusIncrease * (double)col / (double)radius));
                    }
                    byte by = (byte)intensity;
                    alphas[newImageData.width - col - 1] = by;
                    alphas[col] = by;
                    continue;
                }
                if (col > newImageData.width / 2 + newImageData.width % 2) continue;
                alphas[newImageData.width - col - 1] = -1;
                alphas[col] = -1;
            }
            newImageData.setPixels(0, row, radius, pixels, 0);
            newImageData.setPixels(originalImageData.width + radius, row, radius, pixels, 0);
            newImageData.setAlphas(0, row, newImageData.width, alphas, 0);
            newImageData.setPixels(0, newImageData.height - 1 - row, radius, pixels, 0);
            newImageData.setPixels(originalImageData.width + radius, newImageData.height - 1 - row, radius, pixels, 0);
            newImageData.setAlphas(0, newImageData.height - 1 - row, newImageData.width, alphas, 0);
        }
        return newImageData;
    }

    public static Image reflect(Image img, Device device) {
        int height = img.getImageData().height;
        int width = img.getImageData().width;
        Image reflect = new Image(device, width, height / 2);
        GC imageGC = new GC((Drawable)reflect);
        Transform rTransform = new Transform(imageGC.getDevice(), 1.0f, 0.0f, 0.0f, -0.5f, 0.0f, (float)(height / 2));
        imageGC.setTransform(rTransform);
        imageGC.setAlpha(100);
        imageGC.drawImage(img, 0, 0);
        imageGC.dispose();
        return reflect;
    }
}

