/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ColorSpot
extends Canvas {
    private static final int PREFSIZE_DEFAULT = 10;
    private static final RGB COLOR_DEFAULT = new RGB(255, 0, 0);
    private int _preferredSize = 10;
    private Color _spotColor;
    private RGB _spotRGB = COLOR_DEFAULT;

    public ColorSpot(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ColorSpot.this.onPaint(event);
            }
        });
        this.setBackground(parent.getBackground());
    }

    private void onPaint(PaintEvent event) {
        GC gc = event.gc;
        int width = this.getClientArea().width;
        int height = this.getClientArea().height;
        Color bg = gc.getBackground();
        gc.setBackground(this.getColorIntern());
        gc.fillOval(0, 0, width - 1, height - 1);
        gc.setBackground(bg);
        gc.drawOval(0, 0, width - 1, height - 1);
    }

    private Color getColorIntern() {
        if (this._spotColor != null) {
            return this._spotColor;
        }
        this._spotColor = new Color((Device)Display.getCurrent(), this._spotRGB);
        return this._spotColor;
    }

    public RGB getSpotRGB() {
        return this._spotRGB;
    }

    public void setSpotRGB(RGB spotRGB) {
        this._spotRGB = spotRGB;
        if (this._spotColor != null) {
            this._spotColor.dispose();
            this._spotColor = null;
        }
    }

    public void dispose() {
        super.dispose();
        if (this._spotColor != null) {
            this._spotColor.dispose();
        }
    }

    public Point computeSize(int whint, int hhint) {
        if (whint != -1 && hhint != -1) {
            return new Point(whint, hhint);
        }
        if (whint != -1) {
            return new Point(whint, this._preferredSize);
        }
        if (hhint != -1) {
            return new Point(this._preferredSize, hhint);
        }
        return new Point(this._preferredSize, this._preferredSize);
    }

    public Point computeSize(int hint, int hint2, boolean changed) {
        return this.computeSize(hint, hint2);
    }

    public int getPreferredSize() {
        return this._preferredSize;
    }

    public void setPreferredSize(int preferredSize) {
        this._preferredSize = preferredSize;
    }
}

