/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui;

import de.jaret.util.misc.MiscUtil;
import de.jaret.util.ui.DefaultLabelProvider;
import de.jaret.util.ui.model.IMutableContentProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.custom.JaretStyledText;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class CsvListEditor
extends Composite
implements FocusListener,
VerifyListener,
KeyListener,
ModifyListener {
    private ILabelProvider _srcLabelProvider;
    private ILabelProvider _destLabelProvider;
    private IMutableContentProvider _destContentProvider;
    private IStructuredContentProvider _srcContentProvider;
    private String _separator = ",";
    private Map _labelMap = new HashMap();
    private List _labelList = new ArrayList();
    private boolean _caseSensitive = false;
    private boolean _contentParsable = true;
    JaretStyledText _text;
    private boolean ignoreNext = false;

    public CsvListEditor(Composite parent, int style) {
        super(parent, style);
        this._destLabelProvider = this._srcLabelProvider = new DefaultLabelProvider();
        this.createControls();
    }

    private void updateText() {
        StringBuffer buf = new StringBuffer();
        Object[] dest = this._destContentProvider.getElements(null);
        for (int i = 0; i < dest.length; ++i) {
            String label = this._destLabelProvider.getText(dest[i]);
            buf.append(label);
            if (i >= dest.length - 1) continue;
            buf.append(this._separator);
        }
        this._text.setText(buf.toString());
        this._contentParsable = true;
    }

    private boolean updateDest() {
        String input = this._text.getText().trim();
        if (input.endsWith(this._separator)) {
            input = input.substring(0, input.length() - 1);
        }
        StringTokenizer tokenizer = new StringTokenizer(input, this._separator, true);
        boolean success = true;
        ArrayList objects = new ArrayList();
        while (tokenizer.hasMoreTokens()) {
            Object o;
            String token = tokenizer.nextToken();
            if (token.equals(this._separator)) continue;
            token = token.trim();
            if (!this._caseSensitive) {
                token = token.toLowerCase();
            }
            if ((o = this._labelMap.get(token)) == null) {
                success = false;
                break;
            }
            objects.add(o);
        }
        if (success) {
            this._destContentProvider.clear();
            for (int i = 0; i < objects.size(); ++i) {
                this._destContentProvider.addToDest(objects.get(i));
            }
        }
        this._contentParsable = success;
        return success;
    }

    private void createControls() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        GridData gd = new GridData(768);
        this._text = new JaretStyledText(this, 2052);
        this._text.setLayoutData(gd);
        this._text.addFocusListener(this);
        this._text.addModifyListener(this);
    }

    private boolean checkLabelUniqueness(IStructuredContentProvider cp, ILabelProvider lp) {
        boolean result = true;
        HashMap<String, String> labels = new HashMap<String, String>();
        Object[] elements = cp.getElements(null);
        for (int i = 0; i < elements.length; ++i) {
            String label = lp.getText(elements[i]).trim();
            if (!this._caseSensitive) {
                label = label.toLowerCase();
            }
            if (labels.get(label) != null) {
                result = false;
                break;
            }
            labels.put(label, "x");
        }
        return result;
    }

    private void fillLabelMap() {
        Object[] elements = this._srcContentProvider.getElements(null);
        for (int i = 0; i < elements.length; ++i) {
            String label = this._srcLabelProvider.getText(elements[i]).trim();
            if (!this._caseSensitive) {
                label = label.toLowerCase();
            }
            this._labelMap.put(label, elements[i]);
            this._labelList.add(label);
        }
    }

    public void setSrcLabelProvider(ILabelProvider labelProvider) {
        this._srcLabelProvider = labelProvider;
    }

    public void setDestLabelProvider(ILabelProvider labelProvider) {
        this._destLabelProvider = labelProvider;
    }

    public IMutableContentProvider getDestContentProvider() {
        return this._destContentProvider;
    }

    public void setDestContentProvider(IMutableContentProvider destContentProvider) {
        this._destContentProvider = destContentProvider;
        this.updateText();
    }

    public void updateX() {
        this.updateText();
        this.updateDest2(false);
    }

    public IContentProvider getSrcContentProvider() {
        return this._srcContentProvider;
    }

    public void setSrcContentProvider(IStructuredContentProvider srcContentProvider) {
        this._srcContentProvider = srcContentProvider;
        if (!this.checkLabelUniqueness(this._srcContentProvider, this._srcLabelProvider)) {
            throw new RuntimeException("SrcLabels must form a unique key");
        }
        this.fillLabelMap();
    }

    public ILabelProvider getDestLabelProvider() {
        return this._destLabelProvider;
    }

    public ILabelProvider getSrcLabelProvider() {
        return this._srcLabelProvider;
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        boolean success = this.updateDest();
        if (!success) {
            this._text.setBackground(Display.getCurrent().getSystemColor(3));
        } else {
            this._text.setBackground(Display.getCurrent().getSystemColor(1));
            this._text.removeModifyListener(this);
            this.updateText();
            this.updateDest2(false);
            this._text.addModifyListener(this);
        }
    }

    private void resetStyle() {
        this._text.setStyleRanges(new StyleRange[0]);
    }

    private boolean updateDest2(boolean updateDest) {
        String input = MiscUtil.rightTrim(this._text.getText());
        if (input.endsWith(this._separator)) {
            input = input.substring(0, input.length() - 1);
        }
        boolean success = true;
        char separator = this._separator.charAt(0);
        ArrayList objects = new ArrayList();
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        int pos = 0;
        while (pos < input.length()) {
            Object o;
            int beginToken = -1;
            int endToken = -1;
            while (pos < input.length() && Character.isWhitespace(input.charAt(pos))) {
                ++pos;
            }
            beginToken = pos;
            while (pos < input.length() && input.charAt(pos) != separator) {
                ++pos;
            }
            if (beginToken == endToken) break;
            endToken = pos++;
            String token = input.substring(beginToken, endToken);
            token = token.trim();
            if (!this._caseSensitive) {
                token = token.toLowerCase();
            }
            if ((o = this._labelMap.get(token)) == null) {
                success = false;
                continue;
            }
            objects.add(o);
            styleRanges.add(new StyleRange(beginToken, endToken - beginToken, this._text.getForeground(), this._text.getBackground(), 1));
        }
        this._contentParsable = success;
        StyleRange[] srs = new StyleRange[styleRanges.size()];
        for (int i = 0; i < styleRanges.size(); ++i) {
            StyleRange sr;
            srs[i] = sr = (StyleRange)styleRanges.get(i);
        }
        this._text.setStyleRanges(srs);
        return success;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this._caseSensitive = caseSensitive;
    }

    public String getSeparator() {
        return this._separator;
    }

    public void setSeparator(String separator) {
        this._separator = separator;
    }

    public boolean isContentParsable() {
        return this._contentParsable;
    }

    private String possibleLabel(String prefix) {
        if (!this._caseSensitive) {
            prefix = prefix.toLowerCase();
        }
        if (prefix.length() == 0) {
            return "";
        }
        Object o = this._labelMap.get(prefix);
        if (o != null) {
            return prefix;
        }
        for (int i = 0; i < this._labelList.size(); ++i) {
            String label = (String)this._labelList.get(i);
            if (!label.startsWith(prefix)) continue;
            return label;
        }
        return "";
    }

    public void verifyText(VerifyEvent ve) {
    }

    private String getPrefix(String text, int pos) {
        if (text.length() < 1) {
            return "";
        }
        int end = pos;
        while (pos > 0 && !text.substring(pos - 1, pos).equals(this._separator)) {
            --pos;
        }
        String prefix = text.substring(pos, end);
        return MiscUtil.leftTrim(prefix);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void modifyText(ModifyEvent arg0) {
        this.updateDest2(false);
        int pos = this._text.getCaretOffset();
        if (this.ignoreNext) {
            this.ignoreNext = false;
            return;
        }
        System.out.println("modify " + this._text.getText());
        String prefix = this.getPrefix(this._text.getText(), pos);
        String label = this.possibleLabel(prefix);
        if (label.length() > 0) {
            String rest = label.substring(prefix.length());
            System.out.println("Rest:" + rest);
            this._text.removeModifyListener(this);
            this.ignoreNext = true;
            this._text.insert(rest);
            this._text.setSelection(pos, pos + rest.length());
            this._text.setCaretOffsetJaret(pos);
            this._text.addModifyListener(this);
        }
    }

    public void setToolTipText(String toolTip) {
        super.setToolTipText(toolTip);
        this._text.setToolTipText(toolTip);
    }
}

