/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class DoubleField
implements VerifyListener,
KeyListener {
    protected int _digits = 1;
    protected double _min = -1.7976931348623157E308;
    protected double _max = Double.MAX_VALUE;
    protected Text _text;
    protected NumberFormat _numberFormat;
    protected double _increment = 1.0;

    public DoubleField(int digits, double min, double max) {
        this._digits = digits;
        this._min = min;
        this._max = max;
        this.updateNumberFormat();
    }

    public DoubleField() {
        this(1, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public double getValue() throws ParseException {
        double value = this._numberFormat.parse(this._text.getText()).doubleValue();
        return value;
    }

    public void setValue(double value) {
        if (this._text != null) {
            this._text.setText(this._numberFormat.format(value));
        }
    }

    private void updateNumberFormat() {
        if (this._numberFormat == null) {
            this._numberFormat = DecimalFormat.getInstance();
        }
        this._numberFormat.setMaximumFractionDigits(this._digits);
        this._numberFormat.setGroupingUsed(false);
    }

    public int getDigits() {
        return this._digits;
    }

    public void setDigits(int digits) {
        this._digits = digits;
        this.updateNumberFormat();
    }

    public double getMax() {
        return this._max;
    }

    public void setMax(double max) {
        this._max = max;
    }

    public double getMin() {
        return this._min;
    }

    public void setMin(double min) {
        this._min = min;
    }

    public Text getText() {
        return this._text;
    }

    public void setText(Text text) {
        if (this._text != null) {
            this._text.removeVerifyListener((VerifyListener)this);
            this._text.removeKeyListener((KeyListener)this);
        }
        this._text = text;
        if (this._text != null) {
            this._text.addVerifyListener((VerifyListener)this);
            this._text.addKeyListener((KeyListener)this);
        }
    }

    public void verifyText(VerifyEvent e) {
        if (e.text.length() > 1) {
            try {
                this._numberFormat.parse(e.text);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (Character.isDigit(e.character) || e.character < ' ' || e.character == '\u007f') {
            return;
        }
        if ((e.character == '.' || e.character == ',') && this._text.getText().indexOf(46) == -1 && this._text.getText().indexOf(44) == -1) {
            return;
        }
        if (e.character == '-' && this._text.getText().indexOf(45) == -1 && this._text.getCaretPosition() == 0) {
            return;
        }
        e.doit = false;
    }

    public double getIncrement() {
        return this._increment;
    }

    public void setIncrement(double increment) {
        this._increment = increment;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 0x1000002) {
            try {
                double value = this.getValue();
                value -= this._increment;
                if (value < this._min) {
                    value = this._min;
                }
                this.setValue(value);
            }
            catch (ParseException ex) {
                // empty catch block
            }
            e.doit = false;
        } else if (e.keyCode == 0x1000001) {
            try {
                double value = this.getValue();
                value += this._increment;
                if (value > this._max) {
                    value = this._max;
                }
                this.setValue(value);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            e.doit = false;
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

