/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui;

import de.jaret.util.ui.DefaultLabelProvider;
import de.jaret.util.ui.model.IMutableContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ListComposer
extends Composite {
    protected String _srcLabelText = "Source";
    protected String _destLabelText = "Destination";
    protected String _headingLabelText = "Heading";
    protected IMutableContentProvider _destMutableCP;
    protected IContentProvider _srcContentProvider;
    protected ILabelProvider _srcLabelProvider;
    protected ILabelProvider _destLabelProvider;
    private ListViewer _srcViewer;
    private ListViewer _destViewer;
    private Button _remButton;
    private Button _addButton;
    private Button _addAllButton;
    private Button _remAllButton;
    private static final int VIEWERWIDTHHINT = 50;
    private Label _headingLabelWidget;
    private Label _srcLabelWidget;
    private Label _destLabelWidget;

    public ListComposer(Composite parent, int style) {
        super(parent, style);
        this.createControls();
        DefaultLabelProvider dlp = new DefaultLabelProvider();
        this._srcViewer.setLabelProvider((IBaseLabelProvider)dlp);
        this._destViewer.setLabelProvider((IBaseLabelProvider)dlp);
    }

    public void setBackground(Color bgColor) {
        super.setBackground(bgColor);
        Control[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            control.setBackground(bgColor);
        }
    }

    private void createControls() {
        int width = 30;
        ButtonListener buttonListener = new ButtonListener();
        DoubleClickListener doubleClickListener = new DoubleClickListener();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this._headingLabelWidget = new Label((Composite)this, 16384);
        this._headingLabelWidget.setLayoutData((Object)gd);
        this._headingLabelWidget.setText(this._headingLabelText);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this._srcLabelWidget = new Label((Composite)this, 16384);
        this._srcLabelWidget.setLayoutData((Object)gd);
        this._srcLabelWidget.setText(this._srcLabelText);
        gd = new GridData();
        this._destLabelWidget = new Label((Composite)this, 16384);
        this._destLabelWidget.setLayoutData((Object)gd);
        this._destLabelWidget.setText(this._destLabelText);
        gd = new GridData(1808);
        gd.widthHint = 50;
        this._srcViewer = new ListViewer((Composite)this);
        this._srcViewer.getList().setLayoutData((Object)gd);
        this._srcViewer.addDoubleClickListener((IDoubleClickListener)doubleClickListener);
        Composite buttons = new Composite((Composite)this, 0);
        buttons.setLayout((Layout)new RowLayout(512));
        this._remButton = new Button(buttons, 8);
        this._remButton.setText("<");
        Point size = this._remButton.computeSize(-1, -1);
        RowData rd = new RowData(width, size.y);
        this._remButton.setLayoutData((Object)rd);
        this._remButton.addSelectionListener((SelectionListener)buttonListener);
        this._addButton = new Button(buttons, 8);
        this._addButton.setText(">");
        size = this._addButton.computeSize(-1, -1);
        rd = new RowData(width, size.y);
        this._addButton.setLayoutData((Object)rd);
        this._addButton.addSelectionListener((SelectionListener)buttonListener);
        this._addAllButton = new Button(buttons, 8);
        this._addAllButton.setText(">>");
        size = this._addAllButton.computeSize(-1, -1);
        rd = new RowData(width, size.y);
        this._addAllButton.setLayoutData((Object)rd);
        this._addAllButton.addSelectionListener((SelectionListener)buttonListener);
        this._remAllButton = new Button(buttons, 8);
        this._remAllButton.setText("<<");
        size = this._remAllButton.computeSize(-1, -1);
        rd = new RowData(width, size.y);
        this._remAllButton.setLayoutData((Object)rd);
        this._remAllButton.addSelectionListener((SelectionListener)buttonListener);
        gd = new GridData(1808);
        this._destViewer = new ListViewer((Composite)this);
        this._destViewer.getList().setLayoutData((Object)gd);
        gd.widthHint = 50;
        this._destViewer.addDoubleClickListener((IDoubleClickListener)doubleClickListener);
    }

    public void setSrcLabelText(String srcLabelText) {
        this._srcLabelText = srcLabelText;
        this._srcLabelWidget.setText(srcLabelText);
    }

    public void setDestLabelText(String destLabeltext) {
        this._destLabelText = destLabeltext;
        this._destLabelWidget.setText(destLabeltext);
    }

    public void setHeadingLabelText(String heading) {
        this._headingLabelText = heading;
        this._headingLabelWidget.setText(heading);
    }

    public void setSrcContentProvider(IContentProvider contentProvider) {
        this._srcContentProvider = contentProvider;
        this._srcViewer.setContentProvider(contentProvider);
        this._srcViewer.addFilter((ViewerFilter)new Filter());
    }

    public IContentProvider getSrcContentProvider() {
        return this._srcContentProvider;
    }

    public void setDestContentProvider(IMutableContentProvider contentProvider) {
        this._destMutableCP = contentProvider;
        this._destViewer.setContentProvider((IContentProvider)contentProvider);
    }

    public IMutableContentProvider getDestContentProvider() {
        return this._destMutableCP;
    }

    public void setInput(Object input) {
        this._destViewer.setInput(input);
        this._srcViewer.setInput(input);
    }

    public void setSrcLabelProvider(ILabelProvider labelProvider) {
        this._srcViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setDestLabelProvider(ILabelProvider labelProvider) {
        this._destViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public ListViewer getSrcListViewer() {
        return this._srcViewer;
    }

    public ListViewer getDestListViewer() {
        return this._destViewer;
    }

    private void addAll() {
        Object[] all = ((IStructuredContentProvider)this._srcViewer.getContentProvider()).getElements(null);
        for (int i = 0; i < all.length; ++i) {
            this._destMutableCP.addToDest(all[i]);
        }
        this._destViewer.refresh();
        this._srcViewer.refresh();
    }

    private void remAll() {
        Object[] all = this._destMutableCP.getElements(null);
        for (int i = 0; i < all.length; ++i) {
            this._destMutableCP.remFromDest(all[i]);
        }
        this._destViewer.refresh();
        this._srcViewer.refresh();
    }

    private void rem() {
        IStructuredSelection selection = (IStructuredSelection)this._destViewer.getSelection();
        if (!selection.isEmpty()) {
            for (Object item : selection) {
                this._destMutableCP.remFromDest(item);
            }
            this._destViewer.refresh();
            this._srcViewer.refresh();
        }
    }

    private void add() {
        IStructuredSelection selection = (IStructuredSelection)this._srcViewer.getSelection();
        if (!selection.isEmpty()) {
            for (Object item : selection) {
                this._destMutableCP.addToDest(item);
            }
            this._destViewer.refresh();
            this._srcViewer.refresh();
        }
    }

    class Filter
    extends ViewerFilter {
        Filter() {
        }

        public boolean select(Viewer viewer, Object parent, Object item) {
            if (ListComposer.this._destMutableCP != null) {
                return !ListComposer.this._destMutableCP.contains(item);
            }
            return true;
        }
    }

    class DoubleClickListener
    implements IDoubleClickListener {
        DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent dcEvent) {
            Object source = dcEvent.getSource();
            if (source == ListComposer.this._srcViewer) {
                ListComposer.this.add();
            } else if (source == ListComposer.this._destViewer) {
                ListComposer.this.rem();
            }
        }
    }

    private class ButtonListener
    implements SelectionListener {
        private ButtonListener() {
        }

        public void widgetSelected(SelectionEvent selEvent) {
            if (selEvent.getSource() == ListComposer.this._remAllButton) {
                ListComposer.this.remAll();
            } else if (selEvent.getSource() == ListComposer.this._addAllButton) {
                ListComposer.this.addAll();
            } else if (selEvent.getSource() == ListComposer.this._remButton) {
                ListComposer.this.rem();
            } else if (selEvent.getSource() == ListComposer.this._addButton) {
                ListComposer.this.add();
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    }
}

