/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui;

import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SmileyWidget
extends Canvas
implements ChangeListener {
    private double _currentValue = 0.0;
    private BoundedRangeModel _brModel = new DefaultBoundedRangeModel(50, 0, 0, 100);
    private boolean _eyeBrows = true;
    private boolean _colorChange = true;
    private Color _neutral = Display.getCurrent().getSystemColor(7);
    private Color _positive = Display.getCurrent().getSystemColor(5);
    private Color _negative = Display.getCurrent().getSystemColor(3);
    private Color _currentColor;

    public SmileyWidget(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                SmileyWidget.this.onPaint(event);
            }
        });
        this.calcSmileFactor();
        this._brModel.addChangeListener(this);
    }

    private void onPaint(PaintEvent event) {
        GC gc = event.gc;
        int width = this.getClientArea().width;
        int height = this.getClientArea().height;
        int lineWidth = height / 40;
        if (!this._colorChange) {
            gc.setBackground(this._neutral);
        } else if (this._currentValue >= 0.0) {
            gc.setBackground(this.calcColor(this._positive));
        } else {
            gc.setBackground(this.calcColor(this._negative));
        }
        Path p = new Path((Device)Display.getCurrent());
        p.addArc((float)(0 + lineWidth / 2), (float)(0 + lineWidth / 2), (float)(width - 1 - lineWidth), (float)(height - 1 - lineWidth), 0.0f, 360.0f);
        gc.fillPath(p);
        gc.setForeground(Display.getCurrent().getSystemColor(2));
        gc.setLineWidth(lineWidth);
        gc.drawPath(p);
        p.dispose();
        int y = height / 3;
        int x1 = width / 3;
        int x2 = width - width / 3;
        int r = width / 30;
        if (r == 0) {
            r = 1;
        }
        gc.setBackground(Display.getCurrent().getSystemColor(2));
        gc.fillOval(x1 - r, y - r, 2 * r, 2 * r);
        gc.fillOval(x2 - r, y - r, 2 * r, 2 * r);
        if (this._eyeBrows) {
            gc.setLineWidth(lineWidth / 2);
            int ebWidth = width / 10;
            int yDist = height / 13;
            int yOff = (int)(this._currentValue * (double)height / 30.0);
            int xShift = (int)(this._currentValue * (double)width / 90.0);
            p = new Path((Device)Display.getCurrent());
            p.moveTo((float)(x1 - ebWidth / 2 + xShift), (float)(y - yDist + yOff));
            p.lineTo((float)(x1 + ebWidth / 2 - xShift), (float)(y - yDist - yOff));
            gc.drawPath(p);
            p.dispose();
            p = new Path((Device)Display.getCurrent());
            p.moveTo((float)(x2 - ebWidth / 2 + xShift), (float)(y - yDist - yOff));
            p.lineTo((float)(x2 + ebWidth / 2 - xShift), (float)(y - yDist + yOff));
            gc.drawPath(p);
            p.dispose();
        }
        gc.setLineWidth(lineWidth);
        x1 = (int)((double)width / 4.5);
        x2 = width - x1;
        y = height - height / 3;
        int midX = width / 2;
        int offset = (int)(this._currentValue * (double)height / 3.0);
        p = new Path((Device)Display.getCurrent());
        p.moveTo((float)x1, (float)y);
        p.quadTo((float)midX, (float)(y + offset), (float)x2, (float)y);
        gc.drawPath(p);
        p.dispose();
    }

    private void calcSmileFactor() {
        int range = this._brModel.getMaximum() - this._brModel.getMinimum();
        int mid = this._brModel.getMinimum() + range / 2;
        int value = this._brModel.getValue();
        this._currentValue = (double)(value - mid) / (double)(range / 2);
        if (this._currentValue > 1.0) {
            this._currentValue = 1.0;
        } else if (this._currentValue < -1.0) {
            this._currentValue = -1.0;
        }
    }

    public BoundedRangeModel getModel() {
        return this._brModel;
    }

    public void setModel(BoundedRangeModel model) {
        this._brModel.removeChangeListener(this);
        this._brModel = model;
        this._brModel.addChangeListener(this);
        this.calcSmileFactor();
        this.redraw();
    }

    private Color calcColor(Color destColor) {
        int rDiff = destColor.getRed() - this._neutral.getRed();
        int gDiff = destColor.getGreen() - this._neutral.getGreen();
        int bDiff = destColor.getBlue() - this._neutral.getBlue();
        double factor = Math.abs(this._currentValue);
        int r = (int)((double)rDiff * factor);
        int g = (int)((double)gDiff * factor);
        int b = (int)((double)bDiff * factor);
        if (this._currentColor != null) {
            this._currentColor.dispose();
        }
        this._currentColor = new Color((Device)Display.getCurrent(), this._neutral.getRed() + r, this._neutral.getGreen() + g, this._neutral.getBlue() - b);
        return this._currentColor;
    }

    public void dispose() {
        super.dispose();
        if (this._currentColor != null) {
            this._currentColor.dispose();
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.calcSmileFactor();
        this.redraw();
    }

    public boolean getColorChange() {
        return this._colorChange;
    }

    public void setColorChange(boolean colorChange) {
        this._colorChange = colorChange;
        this.redraw();
    }

    public boolean getEyeBrows() {
        return this._eyeBrows;
    }

    public void setEyeBrows(boolean eyeBrows) {
        this._eyeBrows = eyeBrows;
        this.redraw();
    }

    public void setValue(int value) {
        this._brModel.setValue(value);
    }

    public Color getNegative() {
        return this._negative;
    }

    public void setNegative(Color negative) {
        this._negative = negative;
        this.redraw();
    }

    public Color getNeutral() {
        return this._neutral;
    }

    public void setNeutral(Color neutral) {
        this._neutral = neutral;
        this.redraw();
    }

    public Color getPositive() {
        return this._positive;
    }

    public void setPositive(Color positive) {
        this._positive = positive;
        this.redraw();
    }
}

