/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui;

import de.jaret.util.ui.ResourceImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.TableColumn;

public class TableExtension
implements SelectionListener,
DisposeListener {
    boolean _doWidthControl = true;
    long _lastClick = -1L;
    int _lastClickColIdx = -1;
    int _sortingcol = -1;
    int _invert = 1;
    TableViewer _tviewer;
    TableExtensionViewerSorter _sorter;
    private ImageRegistry _imageRegistry;

    public TableExtension(TableViewer tableViewer, boolean doWidthOptimization) {
        this._tviewer = tableViewer;
        TableColumn[] cols = tableViewer.getTable().getColumns();
        for (int i = 0; i < cols.length; ++i) {
            cols[i].addSelectionListener((SelectionListener)this);
        }
        this._sorter = new TableExtensionViewerSorter();
        this.setDoWidthOptimization(doWidthOptimization);
        this._tviewer.getTable().addDisposeListener((DisposeListener)this);
    }

    public TableExtension(TableViewer tableViewer) {
        this(tableViewer, true);
    }

    public void setDoWidthOptimization(boolean doWidthControl) {
        this._doWidthControl = doWidthControl;
    }

    public void widgetSelected(SelectionEvent event) {
        TableColumn tc = (TableColumn)event.getSource();
        int idx = this._tviewer.getTable().indexOf(tc);
        if (this._doWidthControl) {
            if (this._lastClickColIdx != idx) {
                this._lastClickColIdx = idx;
            } else if (System.currentTimeMillis() - this._lastClick < 800L) {
                this.doWidthOpt(idx, tc);
            }
            this._lastClick = System.currentTimeMillis();
        }
        if (this._sortingcol != -1) {
            this._tviewer.getTable().getColumn(this._sortingcol).setImage(null);
        }
        if (this._sortingcol == idx && this._invert == -1) {
            this._sortingcol = -1;
            this._invert = 1;
            this._tviewer.setSorter(null);
        } else {
            this._invert = this._sortingcol == idx ? (this._invert *= -1) : 1;
            this._sortingcol = idx;
            if (this._invert == 1) {
                tc.setImage(this.getImageRegistry().get("down"));
            } else {
                tc.setImage(this.getImageRegistry().get("up"));
            }
            this._tviewer.getTable().setRedraw(false);
            this._tviewer.setComparator(null);
            this._tviewer.setComparator((ViewerComparator)this._sorter);
            this._tviewer.getTable().setRedraw(true);
        }
    }

    private void doWidthOpt(int idx, TableColumn tc) {
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this._tviewer.getContentProvider();
        ITableLabelProvider lprovider = (ITableLabelProvider)this._tviewer.getLabelProvider();
        GC gc = new GC((Drawable)this._tviewer.getTable());
        Object[] items = contentProvider.getElements(this._tviewer.getInput());
        int max = 0;
        for (int i = 0; i < items.length; ++i) {
            String str = lprovider.getColumnText(items[i], idx);
            Point p = gc.textExtent(str);
            if (p.x <= max) continue;
            max = p.x;
        }
        tc.setWidth(max + 20);
        gc.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    private ImageRegistry getImageRegistry() {
        if (this._imageRegistry == null) {
            this._imageRegistry = new ImageRegistry();
            ResourceImageDescriptor imgDesc = new ResourceImageDescriptor("/de/jaret/util/rsc/smallarrow_up.gif");
            this._imageRegistry.put("up", (ImageDescriptor)imgDesc);
            imgDesc = new ResourceImageDescriptor("/de/jaret/util/rsc/smallarrow_down.gif");
            this._imageRegistry.put("down", (ImageDescriptor)imgDesc);
        }
        return this._imageRegistry;
    }

    public void widgetDisposed(DisposeEvent arg0) {
        if (this._imageRegistry != null) {
            this._imageRegistry.dispose();
        }
    }

    private class TableExtensionViewerSorter
    extends ViewerComparator {
        private TableExtensionViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ITableLabelProvider lprovider = (ITableLabelProvider)TableExtension.this._tviewer.getLabelProvider();
            String str1 = lprovider.getColumnText(e1, TableExtension.this._sortingcol);
            String str2 = lprovider.getColumnText(e2, TableExtension.this._sortingcol);
            return this.getComparator().compare(str1, str2) * TableExtension.this._invert;
        }
    }
}

