/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.console;

import de.jaret.util.ui.console.ConsoleListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ConsoleControl
extends Composite
implements VerifyKeyListener {
    private List _enteredLines = new ArrayList();
    private int _currentEnteredLineIdx = -1;
    private List _listeners;
    private String _prompt;
    private int _promptEndIdx;
    private int _promptEndOffset;
    private StyledText _styledText;

    public ConsoleControl(Composite parent, int style, String prompt, String message) {
        super(parent, style);
        this._prompt = prompt;
        this.createControls();
        if (message != null && message.length() > 0) {
            this._styledText.append(message);
            this._styledText.setCaretOffset(this._styledText.getCharCount());
            this.writePrompt(true);
        } else {
            this.writePrompt(false);
        }
    }

    private void createControls() {
        this.setLayout((Layout)new FillLayout());
        this._styledText = new StyledText((Composite)this, 832);
        this._styledText.addVerifyKeyListener((VerifyKeyListener)this);
    }

    private void writePrompt(boolean newLine) {
        if (newLine) {
            this._styledText.append(this._styledText.getLineDelimiter());
        }
        this._styledText.append(this._prompt + " ");
        this._promptEndIdx = this._prompt.length() + 1;
        this._promptEndOffset = this._styledText.getCaretOffset() + this._promptEndIdx + this._styledText.getLineDelimiter().length();
        this._styledText.setCaretOffset(this._promptEndOffset);
        this._styledText.showSelection();
    }

    private int offsetInLine() {
        int caretOffset = this._styledText.getCaretOffset();
        int lineidx = this._styledText.getLineAtOffset(caretOffset);
        int lineoffset = this._styledText.getOffsetAtLine(lineidx);
        int posInLine = caretOffset - lineoffset;
        return posInLine;
    }

    private String getEnteredLine() {
        if (this._promptEndOffset <= this._styledText.getCharCount() - 1) {
            return this._styledText.getText(this._promptEndOffset, this._styledText.getCharCount() - 1);
        }
        return null;
    }

    public void setPrompt(String prompt) {
        this._prompt = prompt;
    }

    public String getPrompt() {
        return this._prompt;
    }

    public void addConsoleListener(ConsoleListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
    }

    public void remConsoleListener(ConsoleListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    protected String fireLineEntered(String line) {
        if (this._listeners != null) {
            StringBuffer result = new StringBuffer();
            for (ConsoleListener listener : this._listeners) {
                String r = listener.lineEntered(this, line);
                if (r == null) continue;
                result.append(r);
            }
            return result.toString();
        }
        return null;
    }

    public void verifyKey(VerifyEvent verifyEvent) {
        switch (verifyEvent.keyCode) {
            case 8: 
            case 0x1000003: {
                System.out.println("left " + this._promptEndIdx + " " + this.offsetInLine());
                if (this.offsetInLine() > this._promptEndIdx) break;
                System.out.println("ignore");
                verifyEvent.doit = false;
                break;
            }
            case 0x1000001: {
                int idx = this._currentEnteredLineIdx - 1;
                if (idx >= 0) {
                    this.replaceEnteredLineWith((String)this._enteredLines.get(idx));
                    this._currentEnteredLineIdx = idx;
                }
                verifyEvent.doit = false;
                break;
            }
            case 0x1000002: {
                int idx2 = this._currentEnteredLineIdx + 1;
                if (idx2 <= this._enteredLines.size() - 1) {
                    this.replaceEnteredLineWith((String)this._enteredLines.get(idx2));
                    this._currentEnteredLineIdx = idx2;
                }
                verifyEvent.doit = false;
                break;
            }
            case 13: {
                String line = this.getEnteredLine();
                this._styledText.setCaretOffset(this._styledText.getCharCount());
                if (line != null) {
                    this._enteredLines.add(line);
                    this._currentEnteredLineIdx = this._enteredLines.size();
                    String result = this.fireLineEntered(line);
                    if (result != null && result.length() > 0) {
                        this._styledText.append(this._styledText.getLineDelimiter());
                        this._styledText.append(result);
                        this._styledText.setCaretOffset(this._styledText.getCharCount());
                    }
                }
                this.writePrompt(true);
                verifyEvent.doit = false;
                break;
            }
        }
    }

    public void output(String text) {
        this._styledText.append(text);
        this._styledText.setCaretOffset(this._styledText.getCaretOffset() + text.length());
        this._styledText.showSelection();
    }

    public PrintStream getPrintStream() {
        return new PrintStream(new ConsoleOutStream(this));
    }

    private void replaceEnteredLineWith(String string) {
        this._styledText.replaceTextRange(this._promptEndOffset, this._styledText.getCharCount() - this._promptEndOffset, string);
        this._styledText.setCaretOffset(this._styledText.getCharCount());
    }

    public class ConsoleOutStream
    extends OutputStream {
        ConsoleControl _consoleControl;

        public ConsoleOutStream(ConsoleControl control) {
            this._consoleControl = control;
        }

        public void write(int b) throws IOException {
            this._consoleControl.output("" + (char)b);
        }
    }
}

