/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.infoprovider;

import de.jaret.util.infoprovider.JaretInfoProvider;
import de.jaret.util.infoprovider.SysInfoEntry;
import de.jaret.util.ui.TableExtension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class InfoProviderView
implements ISelectionChangedListener,
SelectionListener {
    static final int BUTTON_WIDTH = 50;
    Shell _shell;
    private TableViewer _tviewer;
    private Button _closeButton;
    private Button _refreshButton;
    private TreeViewer _treeViewer;
    private JaretInfoProvider _rootProvider;
    private int _accessLevel;

    public InfoProviderView(JaretInfoProvider rootInfoProvider, String title, int accessLevel) {
        this._accessLevel = accessLevel;
        this._shell = new Shell(Display.getCurrent());
        this._rootProvider = rootInfoProvider;
        this._shell.setText(title != null ? title : "Info");
        this._shell.setSize(700, 400);
        this.createControls();
        this._shell.open();
    }

    public Shell getShell() {
        return this._shell;
    }

    protected void createControls() {
        Shell composite = this._shell;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        SashForm sash = new SashForm((Composite)composite, 256);
        sash.setLayoutData((Object)gd);
        this._treeViewer = new TreeViewer((Composite)sash);
        this._treeViewer.setContentProvider((IContentProvider)new IPTreeContentProvider(this._rootProvider));
        this._treeViewer.setInput((Object)"");
        this._treeViewer.setLabelProvider((IBaseLabelProvider)new IPTreeLabelProvider());
        this._treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this._tviewer = new TableViewer((Composite)sash, 67588);
        this._tviewer.setContentProvider((IContentProvider)new IPTableContentProvider());
        this._tviewer.setLabelProvider((IBaseLabelProvider)new IPTableLabelProvider());
        TableColumn column = new TableColumn(this._tviewer.getTable(), 16384);
        column.setText("Name");
        column.setWidth(100);
        column = new TableColumn(this._tviewer.getTable(), 16384);
        column.setText("Value");
        column.setWidth(100);
        this._tviewer.getTable().setHeaderVisible(true);
        TableExtension te = new TableExtension(this._tviewer);
        Composite buttonbar = new Composite((Composite)composite, 0);
        gd = new GridData(128);
        buttonbar.setLayoutData((Object)gd);
        buttonbar.setLayout((Layout)new RowLayout());
        this._refreshButton = new Button(buttonbar, 8);
        this._refreshButton.setText("Refresh");
        Point size = this._refreshButton.computeSize(-1, -1);
        RowData rd = new RowData(50, size.y);
        this._refreshButton.setLayoutData((Object)rd);
        this._refreshButton.addSelectionListener((SelectionListener)this);
        this._closeButton = new Button(buttonbar, 8);
        this._closeButton.setText("Close");
        size = this._closeButton.computeSize(-1, -1);
        rd = new RowData(50, size.y);
        this._closeButton.setLayoutData((Object)rd);
        this._shell.setDefaultButton(this._closeButton);
        this._closeButton.addSelectionListener((SelectionListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object selected = selection.getFirstElement();
        this._tviewer.setInput(selected);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource().equals(this._closeButton)) {
            this._shell.close();
        } else if (event.getSource().equals(this._refreshButton)) {
            this._treeViewer.refresh();
            this._tviewer.refresh();
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    class IPTableLabelProvider
    implements ITableLabelProvider {
        IPTableLabelProvider() {
        }

        public String getColumnText(Object obj, int i) {
            String result;
            SysInfoEntry entry = (SysInfoEntry)obj;
            switch (i) {
                case 0: {
                    result = entry.name;
                    break;
                }
                case 1: {
                    result = entry.value;
                    break;
                }
                default: {
                    result = "error - unknow column";
                }
            }
            return result;
        }

        public void addListener(ILabelProviderListener ilabelproviderlistener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void removeListener(ILabelProviderListener ilabelproviderlistener) {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }
    }

    class IPTableContentProvider
    implements IStructuredContentProvider {
        IPTableContentProvider() {
        }

        public Object[] getElements(Object element) {
            JaretInfoProvider ip = (JaretInfoProvider)element;
            Object[] kids = null;
            List<SysInfoEntry> l = ip.getSysInfoEntries();
            ArrayList<SysInfoEntry> lout = new ArrayList<SysInfoEntry>();
            for (SysInfoEntry entry : l) {
                if (entry.access > InfoProviderView.this._accessLevel) continue;
                lout.add(entry);
            }
            kids = lout.toArray();
            return kids;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old_object, Object new_object) {
        }
    }

    class IPTreeLabelProvider
    extends LabelProvider {
        IPTreeLabelProvider() {
        }

        public String getText(Object o) {
            JaretInfoProvider ip = (JaretInfoProvider)o;
            String text = ip.getInfoProviderName();
            return text;
        }
    }

    public class IPTreeContentProvider
    implements ITreeContentProvider {
        Map _parentMap = new HashMap();
        JaretInfoProvider _root;

        public IPTreeContentProvider(JaretInfoProvider root) {
            this._root = root;
        }

        public Object[] getChildren(Object arg0) {
            List<JaretInfoProvider> l = ((JaretInfoProvider)arg0).getSubInfoProviders();
            if (l == null) {
                return new Object[0];
            }
            return l.toArray();
        }

        public Object getParent(Object arg0) {
            Object parent = this._parentMap.get(arg0);
            if (parent == null) {
                parent = this.findParent(this._root, (JaretInfoProvider)arg0);
                this._parentMap.put(arg0, parent);
            }
            System.out.println("PARENT " + parent);
            return parent;
        }

        private JaretInfoProvider findParent(JaretInfoProvider base, JaretInfoProvider child) {
            List<JaretInfoProvider> l = base.getSubInfoProviders();
            if (l == null) {
                return null;
            }
            for (int i = 0; i < l.size(); ++i) {
                JaretInfoProvider ip = l.get(i);
                if (ip.equals(child)) {
                    return base;
                }
                JaretInfoProvider ipNext = this.findParent(ip, child);
                if (ipNext == null) continue;
                return ipNext;
            }
            return null;
        }

        public boolean hasChildren(Object arg0) {
            if (arg0 instanceof String) {
                return true;
            }
            return this.getChildren(arg0).length > 0;
        }

        public Object[] getElements(Object arg0) {
            if (arg0 instanceof String) {
                return new Object[]{this._root};
            }
            return this.getChildren(arg0);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }
    }
}

