/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal.snmp;

import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpUsmKeyHandler;
import com.sun.management.snmp.usm.SnmpUsmAlgorithm;
import com.sun.management.snmp.usm.SnmpUsmAlgorithmManager;
import com.sun.management.snmp.usm.SnmpUsmAuthAlgorithm;

public class SnmpUsmKeyHandlerImpl
implements SnmpUsmKeyHandler {
    SnmpUsmAlgorithmManager manager = null;

    SnmpUsmKeyHandlerImpl(SnmpUsmAlgorithmManager manager) {
        this.manager = manager;
    }

    private SnmpUsmAuthAlgorithm getAlgo(String name) throws IllegalArgumentException {
        SnmpUsmAlgorithm algo = this.manager.getAlgorithm(name);
        SnmpUsmAuthAlgorithm auth = null;
        if (!(algo instanceof SnmpUsmAuthAlgorithm)) {
            throw new IllegalArgumentException(" Not an authetication algorithm");
        }
        auth = (SnmpUsmAuthAlgorithm)algo;
        if (auth == null) {
            throw new IllegalArgumentException("Unknown algorithm : " + name);
        }
        return auth;
    }

    public byte[] password_to_key(String algoName, String password) throws IllegalArgumentException {
        return this.getAlgo(algoName).password_to_key(password);
    }

    public byte[] localizeAuthKey(String algoName, byte[] key, SnmpEngineId engineId) throws IllegalArgumentException {
        return this.getAlgo(algoName).localizeAuthKey(key, engineId);
    }

    public byte[] localizePrivKey(String algoName, byte[] key, SnmpEngineId engineId, int keysize) throws IllegalArgumentException {
        return this.getAlgo(algoName).localizePrivKey(key, engineId, keysize);
    }

    public byte[] calculateAuthDelta(String algoName, byte[] oldKey, byte[] newKey, byte[] random) throws IllegalArgumentException {
        return this.getAlgo(algoName).calculateAuthDelta(oldKey, newKey, random);
    }

    public byte[] calculatePrivDelta(String algoName, byte[] oldKey, byte[] newKey, byte[] random, int deltaSize) throws IllegalArgumentException {
        return this.getAlgo(algoName).calculatePrivDelta(oldKey, newKey, random, deltaSize);
    }
}

