/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectSubID;
import com.sun.jdmk.tools.mibgen.IdentifierHandler;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.Node;
import com.sun.jdmk.tools.mibgen.Parser;
import com.sun.jdmk.tools.mibgen.SemanticException;
import com.sun.jdmk.tools.mibgen.SimpleNode;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import com.sun.jdmk.tools.mibgen.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ASTOidValue
extends SimpleNode {
    static byte[] byteTab = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    protected StringBuffer dotNotation = null;

    ASTOidValue(int id) {
        super(id);
    }

    ASTOidValue(Parser p, int id) {
        super(p, id);
    }

    public static Node jjtCreate(int id) {
        return new ASTOidValue(id);
    }

    public static Node jjtCreate(Parser p, int id) {
        return new ASTOidValue(p, id);
    }

    public void resolve(IdentifierHandler handler) {
        int nb = this.children.length;
        if (nb == 0) {
            return;
        }
        for (int index = 0; index < nb; ++index) {
            SimpleNode aNode = (SimpleNode)this.children[index];
            if (aNode.id != 31) continue;
            ((ASTObjectSubID)aNode).resolve(handler);
        }
    }

    public void resolve(IdentifierHandler handler, String key) {
        handler.addResolution(key, this);
        this.resolve(handler);
    }

    public StringBuffer computeValue(Vector referenceList) throws SemanticException {
        StringBuffer result = new StringBuffer();
        if (this.children == null || this.children.length == 0) {
            return result;
        }
        boolean first = true;
        for (int i = 0; i < this.children.length; ++i) {
            if (!first) {
                result.append(".");
            } else {
                first = false;
            }
            ASTObjectSubID subId = (ASTObjectSubID)this.children[i];
            result.append((Object)subId.computeValue(referenceList));
        }
        this.dotNotation = result;
        return result;
    }

    public String getDefValBITS() {
        if (this.children == null || this.children.length != 1) {
            return null;
        }
        ASTObjectSubID subId = (ASTObjectSubID)this.children[0];
        return subId.getDefValBITS();
    }

    public StringBuffer getDotNotation() {
        if (this.dotNotation == null) {
            try {
                this.dotNotation = this.computeValue(new Vector());
            }
            catch (SemanticException e) {
                this.dotNotation = null;
            }
        }
        return this.dotNotation;
    }

    public String getDefValInitializer(String strMbeanSyntax, ASTNamedType syntax, String varName) {
        String result = new String();
        int intSnmpSyntax = SyntaxMapper.getIntSnmpSyntax(syntax.getSnmpSyntax());
        switch (intSnmpSyntax) {
            case 11: {
                StringBuffer dotString = this.getDotNotation();
                if (dotString == null) break;
                result = new String(" = new " + strMbeanSyntax.trim() + "(\"" + dotString + "\")");
                break;
            }
            case 10: {
                if (!syntax.isEnumeratedBITSType()) break;
                String strDefVal = this.getDefValBITS();
                Hashtable enumeration = syntax.getEnumeratedBITSDef().getEnum();
                String defValBITS = this.calculateDefValBITS(enumeration, strDefVal);
                if (defValBITS != null) {
                    result = " = {" + defValBITS + "}";
                    break;
                }
                Trace.warning(MessageHandler.getMessage("compile.w.defval", strDefVal, varName));
                break;
            }
        }
        return result;
    }

    String calculateDefValBITS(Hashtable enumeration, String strDefVal) {
        int i;
        StringBuffer result = new StringBuffer();
        int maxIntDefVal = 0;
        Enumeration e = enumeration.elements();
        while (e.hasMoreElements()) {
            maxIntDefVal = Math.max(maxIntDefVal, new Integer((String)e.nextElement()));
        }
        int intDefVal = 0;
        try {
            intDefVal = new Integer((String)enumeration.get(strDefVal));
        }
        catch (NumberFormatException e2) {
            return null;
        }
        int nbBytes = maxIntDefVal / 8 + 1;
        byte[] b = new byte[nbBytes];
        for (i = 0; i < nbBytes; ++i) {
            b[i] = 0;
        }
        b[intDefVal / 8] = byteTab[7 - intDefVal % 8];
        for (i = 0; i < nbBytes; ++i) {
            result.append(" new Byte(\"");
            result.append(b[i]);
            result.append("\")");
            if (i >= nbBytes - 1) continue;
            result.append(",");
        }
        return new String(result);
    }
}

