/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.GroupGenerator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibGenerator;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.MibTree;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class CodeGenerator
extends Generator
implements Serializable {
    protected GroupGenerator groupGenerator = null;
    protected String domainSeparator = "_";

    public CodeGenerator(ResourceManager mgr, Context ctxt) {
        super(mgr, ctxt);
        this.groupGenerator = new GroupGenerator(mgr, ctxt.duplicate());
    }

    public void addExternalSymbol(Context ctxt, String symbolName) {
        this.groupGenerator.addExternalSymbol(ctxt, symbolName);
    }

    public void generateCode(ASTMib aMib, int type) throws IOException {
        Context ctxt = this.context.duplicate();
        ctxt.mib = aMib;
        ctxt.gentype = type;
        ctxt.codegen = this;
        MibGenerator gen = new MibGenerator(this.manager, aMib, ctxt);
        gen.setDomainSeparator(this.domainSeparator);
        ctxt.mibgen = gen;
        MibTree tree = aMib.getMibTree();
        MibNode node = tree.getRoot();
        this.groupGenerator.setContext(ctxt);
        this.setContext(ctxt);
        this.buildSymbolTable(ctxt, gen, node);
        this.generateCode(ctxt, gen, node);
        gen.endMib();
    }

    private void generateCode(Context ctxt, MibGenerator gen, MibNode node) throws IOException {
        this.generateNode(ctxt, gen, node, null, null);
    }

    private void buildSymbolTable(Context ctxt, MibGenerator gen, MibNode node) throws IOException {
        this.buildSymbolTable(ctxt, gen, node, null, null);
    }

    private void buildSymbolTable(Context ctxt, MibGenerator gen, MibNode node, MibNode group, String domain) throws IOException {
        if (node.isGroup()) {
            try {
                node.isValidGroup();
            }
            catch (IOException e) {
                String oid = e.getMessage();
                String nodeOid = this.getClassName(node.getComputedOid());
                String msg = MessageHandler.getMessage("generate.error.mib", nodeOid, this.getClassName(oid));
                gen.endMib();
                throw e;
            }
            this.groupGenerator.buildSymbolTable(node, ctxt);
            if (!node.hasNestedGroups()) {
                return;
            }
            String symbol = CodeGenerator.getSymbolName(ctxt, node);
            if (symbol != null) {
                domain = this.appendName(domain, symbol);
            }
            group = node;
        }
        Hashtable children = node.getChildren();
        Enumeration e = children.elements();
        while (e.hasMoreElements()) {
            this.buildSymbolTable(ctxt, gen, (MibNode)e.nextElement(), group, domain);
        }
    }

    private void generateNode(Context ctxt, MibGenerator gen, MibNode node, MibNode group, String domain) throws IOException {
        if (node.isGroup()) {
            try {
                node.isValidGroup();
            }
            catch (IOException e) {
                String oid = e.getMessage();
                String nodeOid = this.getClassName(node.getComputedOid());
                String msg = MessageHandler.getMessage("generate.error.mib", nodeOid, this.getClassName(oid));
                gen.endMib();
                throw e;
            }
            this.groupGenerator.generateCode(node, ctxt);
            gen.registerNode(node, ctxt, domain);
            if (!node.hasNestedGroups()) {
                return;
            }
            String symbol = CodeGenerator.getSymbolName(ctxt, node);
            if (symbol != null) {
                domain = this.appendName(domain, symbol);
            }
            group = node;
        }
        Hashtable children = node.getChildren();
        Enumeration e = children.elements();
        while (e.hasMoreElements()) {
            this.generateNode(ctxt, gen, (MibNode)e.nextElement(), group, domain);
        }
    }

    public String appendName(String domain, String name) {
        if (domain == null) {
            return name;
        }
        if (name == null) {
            return domain;
        }
        return new String(domain + this.domainSeparator + name);
    }

    public static String getSymbolName(Context ctxt, MibNode node) {
        if (node == null) {
            return null;
        }
        if (node.getSymbolName() != null) {
            return node.getSymbolName();
        }
        String symbol = ctxt.mib.getAssociatedSymbol(node.getComputedOid());
        if (symbol == null) {
            return null;
        }
        String result = symbol.trim();
        result = result.replace('-', '_');
        result = result.replace('.', '_');
        result = result.replace(',', '_');
        result = result.replace(',', '_');
        result = result.replace(' ', '_');
        return Character.toUpperCase(result.charAt(0)) + result.substring(1, result.length());
    }

    public String setDomainSeparator(String s) {
        if (s != null) {
            this.domainSeparator = s;
        }
        return this.domainSeparator;
    }
}

