/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Hashtable;

public abstract class Generator
implements Serializable {
    protected ASTMib mib;
    protected String packageName = "";
    protected String prefix = "";
    protected String targetDir = "";
    protected File targetFile;
    protected RandomAccessFile out;
    ResourceManager manager;
    Context context;
    private String defaultOidPrefix = "oid_";

    public Generator(ResourceManager manager, Context ctxt) {
        this.manager = manager;
        this.packageName = ctxt.packageName;
        this.prefix = ctxt.prefix;
        this.targetDir = ctxt.dir;
        this.context = ctxt;
        this.defaultOidPrefix = ctxt.defaultOidPrefix;
    }

    public void setContext(Context ctxt) {
        this.packageName = ctxt.packageName;
        this.prefix = ctxt.prefix;
        this.targetDir = ctxt.dir;
        this.defaultOidPrefix = ctxt.defaultOidPrefix;
        this.context = ctxt;
    }

    public void setMib(ASTMib aMib) {
        this.mib = aMib;
        this.context.mib = aMib;
    }

    protected boolean isRowStatus(Context ctxt, String var) {
        String typeRef = ctxt.getTypeRef(var);
        if (typeRef == null) {
            return false;
        }
        return typeRef.equals("RowStatus");
    }

    protected RandomAccessFile openFile(String name) throws IOException {
        File f = this.checkFile(name);
        return new RandomAccessFile(f, "rw");
    }

    protected synchronized void write(String msg) throws IOException {
        try {
            this.out.writeBytes(msg);
        }
        catch (IOException e) {
            throw new IOException(e.toString());
        }
    }

    protected void writeVersion() throws IOException {
        String msgid = "generate.version";
        if (this.isGeneric()) {
            msgid = "generate.version.generic";
        } else if (this.isStandard()) {
            msgid = "generate.version.standard";
        }
        this.write("\n//\n// " + MessageHandler.getMessage(msgid, this.mib.getModuleName()) + "\n//\n\n");
    }

    protected void writePkg() throws IOException {
        if (this.packageName.length() != 0) {
            this.write(Def.PACKAGE + this.packageName + Def.SEMICOLON);
        }
        this.writeVersion();
    }

    protected String translateOid(String oid) {
        return Generator.translateOid(this.context, oid);
    }

    public static String translateOid(Context ctxt, String oid) {
        if (ctxt.prefix == null || ctxt.prefix.length() == 0) {
            return ctxt.defaultOidPrefix + oid.replace('.', '_');
        }
        return oid.replace('.', '_');
    }

    boolean isStandard() {
        return (this.context.gentype & 1) != 0;
    }

    boolean isGeneric() {
        return (this.context.gentype & 2) != 0;
    }

    private File checkFile(String name) throws IOException {
        File f = this.targetDir.length() != 0 ? new File(this.targetDir, name) : new File(name);
        if (f.exists()) {
            String sname = name + "~";
            File f1 = new File(this.targetDir, sname);
            if (f1.exists()) {
                f1.delete();
            }
            if (!f.renameTo(f1)) {
                Trace.error(MessageHandler.getMessage("compile.error.noWritePermission", f.getName()));
                throw new IOException("The file " + f.getName() + " belongs to another user");
            }
        }
        return f;
    }

    public static String getClassName(Context ctxt, String oid) {
        Hashtable oidTranslation = ctxt.mib.oidTranslation;
        String symbol = (String)oidTranslation.get(oid);
        if (symbol == null) {
            symbol = Generator.translateOid(ctxt, oid);
        }
        String result = symbol.trim();
        result = result.replace('-', '_');
        result = result.replace('.', '_');
        result = result.replace(',', '_');
        result = result.replace(',', '_');
        result = result.replace(' ', '_');
        return Character.toUpperCase(result.charAt(0)) + result.substring(1, result.length());
    }

    protected String getClassName(String oid) {
        return Generator.getClassName(this.context, oid);
    }

    protected void closeIO() throws IOException {
        this.out.close();
    }
}

