/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.BeanGenerator;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MetaTableGenerator;
import com.sun.jdmk.tools.mibgen.MibGenProperties;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import com.sun.jdmk.tools.mibgen.Trace;
import java.io.IOException;
import java.io.Serializable;

public class MetaBeanGenerator
extends BeanGenerator
implements Serializable {
    public static final int STANDARD_META = 1;
    public static final int GENERIC_META = 2;
    int gentype = 0;
    protected StringBuffer isVariable_impl;
    protected StringBuffer isVariableBody_impl;
    protected int readCount = 0;
    protected StringBuffer isReadable_impl;
    protected StringBuffer isReadableBody_impl;
    protected StringBuffer getNext_impl;
    protected StringBuffer skipVar_impl;
    protected StringBuffer skipVarBody_impl;
    protected int skipVarCount;
    protected int totalSkipVarCount;
    protected StringBuffer get_impl;
    protected StringBuffer getVar_impl;
    protected StringBuffer getReq_impl;
    protected StringBuffer set_impl;
    protected StringBuffer setVar_impl;
    protected StringBuffer setReq_impl;
    protected StringBuffer check_impl;
    protected StringBuffer checkVar_impl;
    protected StringBuffer checkReq_impl;
    protected StringBuffer init_impl;
    protected StringBuffer var_def;
    protected StringBuffer moi_impl;
    protected StringBuffer objsrv_impl;
    protected StringBuffer buildval_impl;
    protected StringBuffer buildatt_impl;
    protected StringBuffer attname_impl;
    protected StringBuffer checkset_impl;
    protected StringBuffer checkget_impl;
    protected StringBuffer objname_impl;
    protected StringBuffer constructor;
    protected StringBuffer accessors;
    protected static String MBEAN_NAME = "node";
    protected static String OBJSRV = "objectserver";
    protected int counter = 0;
    protected int varCount = 0;

    public static String buildMetaName(Context ctxt, String pre, String name) {
        if (ctxt.gentype == 2) {
            return pre + name + ctxt.genericPrefix + Def.METAPREFIX;
        }
        if (ctxt.gentype == 1) {
            return pre + name + ctxt.standardPrefix + Def.METAPREFIX;
        }
        return pre + name + Def.METAPREFIX;
    }

    public static String getNodeSymbolName(Context ctxt, MibNode node) {
        String vName = node.getSymbolName();
        if (vName == null) {
            vName = Generator.getClassName(ctxt, node.getComputedOid());
        }
        String sName = MetaBeanGenerator.buildMetaName(ctxt, ctxt.prefix, vName);
        return sName;
    }

    String getNodeSymbolName(MibNode node) {
        return MetaBeanGenerator.getNodeSymbolName(this.context, node);
    }

    public MetaBeanGenerator(ResourceManager mgr, MibNode aGroup, Context ctxt) throws IOException {
        super(mgr, aGroup, ctxt);
        this.gentype = ctxt.gentype;
        this.oid = this.node.getComputedOid();
        this.varName = this.node.getSymbolName();
        if (this.varName == null) {
            this.varName = this.getClassName(this.node.getComputedOid());
        }
        this.symboleName = this.getNodeSymbolName(this.node);
        Trace.info(MessageHandler.getMessage("generate.info.meta", this.varName));
        this.out = this.openFile(this.symboleName + Def.JAVA);
        this.initBuffers();
        this.writeHeader();
        this.writeClassDeclaration();
        this.buildVarList();
        this.buildConstructorHeader();
        this.buildMethodHeaders();
    }

    public void setContext(Context ctxt) {
        super.setContext(ctxt);
        this.gentype = ctxt.gentype;
    }

    boolean isStandard() {
        return (this.gentype & 1) != 0;
    }

    boolean isGeneric() {
        return (this.gentype & 2) != 0;
    }

    protected void initBuffers() {
        this.isVariable_impl = new StringBuffer();
        this.isVariableBody_impl = new StringBuffer();
        this.isReadable_impl = new StringBuffer();
        this.isReadableBody_impl = new StringBuffer();
        this.skipVarCount = 0;
        this.totalSkipVarCount = 0;
        this.skipVar_impl = new StringBuffer();
        this.skipVarBody_impl = new StringBuffer();
        if (this.isStandard()) {
            this.getVar_impl = new StringBuffer();
            this.setVar_impl = new StringBuffer();
            this.checkVar_impl = new StringBuffer();
            this.moi_impl = new StringBuffer();
        }
        this.getReq_impl = new StringBuffer();
        this.setReq_impl = new StringBuffer();
        this.checkReq_impl = new StringBuffer();
        this.init_impl = new StringBuffer();
        this.var_def = new StringBuffer();
        this.objsrv_impl = new StringBuffer();
        this.constructor = new StringBuffer();
        this.accessors = new StringBuffer();
        if (this.isGeneric()) {
            this.buildval_impl = new StringBuffer();
            this.buildatt_impl = new StringBuffer();
            this.checkset_impl = new StringBuffer();
            this.checkget_impl = new StringBuffer();
            this.objname_impl = new StringBuffer();
        }
        this.attname_impl = new StringBuffer();
    }

    protected void buildMethodHeaders() throws IOException {
        if (this.isStandard()) {
            this.buildSetInstance();
        }
        if (this.isGeneric()) {
            this.buildSetObjectName();
        }
        if (this.isStandard()) {
            this.buildGetVarHeader();
            this.buildSetVarHeader();
            this.buildCheckVarHeader();
        }
        this.buildGetAttNameHeader();
        if (this.isGeneric()) {
            this.buildBuildValHeader();
            this.buildBuildAttHeader();
            this.buildCheckSetAccessHeader();
            this.buildCheckGetAccessHeader();
        }
        this.buildGet();
        this.buildSet();
        this.buildCheck();
        this.buildIsVariableHeader();
        this.buildIsReadableHeader();
        this.buildSkipVarHeader();
    }

    protected void closeMethods() throws IOException {
        if (this.isStandard()) {
            this.closeGetVarMeth();
            this.closeSetVarMeth();
            this.closeCheckVarMeth();
        }
        this.closeGetAttNameMeth();
        if (this.isGeneric()) {
            this.closeBuildValMeth();
            this.closeBuildAttMeth();
            this.closeCheckSetAccessMeth();
            this.closeCheckGetAccessMeth();
        }
        this.closeIsVariableMeth();
        this.closeIsReadableMeth();
        this.closeSkipVarMeth();
    }

    protected void writeMethods() throws IOException {
        if (this.isStandard()) {
            this.write(this.getVar_impl.toString());
            this.write(this.setVar_impl.toString());
            this.write(this.checkVar_impl.toString());
            this.write(this.moi_impl.toString());
        }
        this.write(this.getReq_impl.toString());
        this.write(this.setReq_impl.toString());
        this.write(this.checkReq_impl.toString());
        this.write(this.isVariable_impl.toString());
        this.write(this.isReadable_impl.toString());
        this.write(this.skipVar_impl.toString());
        this.write(this.objsrv_impl.toString());
        this.write(this.attname_impl.toString());
        if (this.isGeneric()) {
            this.write(this.buildval_impl.toString());
            this.write(this.buildatt_impl.toString());
            this.write(this.checkset_impl.toString());
            this.write(this.checkget_impl.toString());
            this.write(this.objname_impl.toString());
        }
    }

    public void endOfGroup() throws IOException {
        this.closeMethods();
        this.closeConstructor();
        this.write(this.constructor.toString());
        this.writeMethods();
        this.write(this.var_def.toString());
        this.write(Def.RBRACE);
        this.closeIO();
    }

    public void handleNode(MibNode aNode) throws IOException {
        String varName = aNode.getSymbolName();
        String id = aNode.getNodeId();
        if (aNode.isGroup() || aNode.hasNestedGroups()) {
            this.handleNestedGroups(aNode);
            return;
        }
        if (aNode.isTable()) {
            Trace.info(MessageHandler.getMessage("generate.info.var", aNode.getSymbolName()));
            this.handleTable(aNode);
            this.handleInit(id, varName, 67);
            return;
        }
        ASTObjectTypeDefinition definition = aNode.getObjectType();
        int access = definition.getDefinition().getAccess();
        ASTNamedType syntaxObject = definition.getSyntax();
        String syntax = syntaxObject.getSnmpSyntax();
        aNode.setSnmpSyntax(syntax);
        String enumtype = null;
        if (aNode.isEnumeratedType()) {
            enumtype = aNode.getEnumeratedType();
        }
        this.handleMinMax(id);
        this.handleVariableId(id, varName, syntax, enumtype, access);
        String refName = this.context.getTypeRef(varName);
        if (this.isStandard()) {
            this.handleGetVar(id, varName, syntax, access);
        }
        this.handleGetAttName(id, varName, syntax, access);
        if (this.isStandard() && (!this.isRowStatus(this.context, varName) || MibGenProperties.isDeprecatedEnabled())) {
            this.handleCheckVar(id, varName, syntax, enumtype, access);
        }
        if (this.isStandard()) {
            this.handleSetVar(id, varName, syntax, enumtype, access);
        }
        if (this.isGeneric()) {
            this.handleBuildVal(id, varName, syntax, enumtype, access);
            this.handleBuildAtt(id, varName, syntax, enumtype, access);
            this.handleCheckSetAccess(id, varName, syntax, enumtype, access);
            this.handleCheckGetAccess(id, varName, syntax, enumtype, access);
        }
        this.handleInit(id, varName, access);
        ++this.varCount;
    }

    protected void handleNestedGroups(MibNode node) throws IOException {
    }

    protected void handleTableId(MibNode aNode, String name, String id) throws IOException {
        if (this.isStandard()) {
            this.handleGetVarTable(aNode, name, id);
            this.handleSetVarTable(aNode, name, id);
            this.handleCheckVarTable(aNode, name, id);
        }
        this.handleGetAttNameTable(aNode, name, id);
        if (this.isGeneric()) {
            this.handleBuildValTable(aNode, name, id);
            this.handleBuildAttTable(aNode, name, id);
            this.handleCheckSetAccessTable(aNode, name, id);
            this.handleCheckGetAccessTable(aNode, name, id);
        }
    }

    protected void handleGetVarTable(MibNode aNode, String varName, String id) throws IOException {
        this.getVar_impl.append(Def.TAB3 + "case " + id + ":" + Def.LBRACE);
        this.getVar_impl.append(Def.TAB4 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHINSTANCE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
    }

    protected void handleGetAttNameTable(MibNode aNode, String varName, String id) throws IOException {
        this.attname_impl.append(Def.TAB3 + "case " + id + ":" + Def.LBRACE);
        this.attname_impl.append(Def.TAB4 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHINSTANCE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
    }

    protected void handleSetVarTable(MibNode aNode, String varName, String id) throws IOException {
        this.setVar_impl.append(Def.TAB3 + "case " + id + ":" + Def.LBRACE);
        this.setVar_impl.append(Def.TAB4 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOTWRITABLE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
    }

    protected void handleBuildValTable(MibNode aNode, String varName, String id) throws IOException {
        this.buildval_impl.append(Def.TAB3 + "case " + id + ":" + Def.LBRACE);
        this.buildval_impl.append(Def.TAB4 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHINSTANCE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
    }

    protected void handleBuildAttTable(MibNode aNode, String varName, String id) throws IOException {
        this.buildatt_impl.append(Def.TAB3 + "case " + id + ":" + Def.LBRACE);
        this.buildatt_impl.append(Def.TAB4 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHINSTANCE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
    }

    protected void handleCheckVarTable(MibNode aNode, String varName, String id) throws IOException {
        this.checkVar_impl.append(Def.TAB3 + "case " + id + ":" + Def.LBRACE);
        this.checkVar_impl.append(Def.TAB4 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOTWRITABLE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
    }

    protected void handleCheckSetAccessTable(MibNode aNode, String varName, String id) throws IOException {
        this.checkset_impl.append(Def.TAB3 + "case " + id + ":" + Def.LBRACE);
        this.checkset_impl.append(Def.TAB4 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOTWRITABLE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
    }

    protected void handleCheckGetAccessTable(MibNode aNode, String varName, String id) throws IOException {
        this.checkget_impl.append(Def.TAB3 + "case " + id + ":" + Def.LBRACE);
        this.checkget_impl.append(Def.TAB4 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHINSTANCE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
    }

    protected void handleTable(MibNode aNode) throws IOException {
        String varName = aNode.getSymbolName();
        String id = aNode.getNodeId();
        this.handleTableId(aNode, varName, id);
        MetaTableGenerator metatable = new MetaTableGenerator(this.manager, aNode, this.context);
        metatable.generateCode();
    }

    protected void handleInit(String id, String var, int acc) throws IOException {
        if (acc == 67 || acc == 66 || acc == 68) {
            this.init_impl.append(Def.TAB2 + Def.SNMP_VARLIST + "[" + String.valueOf(this.counter) + "] = " + id + Def.SEMICOLON);
            ++this.counter;
        }
    }

    protected void handleVariableId(String id, String var, String entry, String enumtype, int acc) throws IOException {
        this.handleIsVariable(id, var, entry, acc);
        this.handleIsReadable(id, var, entry, acc);
        this.handleSkipVar(id, var, entry, acc);
    }

    protected void handleIsVariable(String id, String var, String entry, int acc) throws IOException {
        this.isVariableBody_impl.append(Def.TAB3 + "case " + id + ":\n");
    }

    protected void handleIsReadable(String id, String var, String entry, int acc) throws IOException {
        if (acc == 85 || acc == 47 || acc == 7) {
            return;
        }
        ++this.readCount;
        this.isReadableBody_impl.append(Def.TAB3 + "case " + id + ":\n");
    }

    protected void handleGetVar(String id, String var, String entry, int acc) throws IOException {
        this.getVar_impl.append(Def.TAB3 + "case " + id + ":\n" + Def.TAB4);
        if (acc == 85 || acc == 47 || acc == 7) {
            this.getVar_impl.append(Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHINSTANCE + ")" + Def.SEMICOLON);
            return;
        }
        String syntax = SyntaxMapper.getTypeName(entry);
        this.getVar_impl.append("return new " + syntax + "(" + MBEAN_NAME + "." + Def.GET + var + "())" + Def.SEMICOLON + "\n");
    }

    protected void genSkipVarCode(StringBuffer result) throws IOException {
        result.append(Def.TAB4 + "if (pduVersion==" + Def.C_SNMP_VERSION1 + ") return " + "true" + Def.SEMICOLON);
        result.append(Def.TAB4 + "break" + Def.SEMICOLON);
    }

    protected void handleSkipVar(String id, String var, String entry, int acc) throws IOException {
        if (acc == 85 || acc == 47 || acc == 7) {
            if (this.skipVarCount > 0) {
                this.genSkipVarCode(this.skipVarBody_impl);
                this.skipVarCount = 0;
            }
            this.skipVarBody_impl.append(Def.TAB3 + "case " + id + ":\n" + Def.TAB4);
            this.skipVarBody_impl.append("return true" + Def.SEMICOLON);
            ++this.totalSkipVarCount;
            return;
        }
        if (SyntaxMapper.isV2Syntax(entry)) {
            this.skipVarBody_impl.append(Def.TAB3 + "case " + id + ":\n");
            ++this.skipVarCount;
            ++this.totalSkipVarCount;
        }
    }

    protected void handleGetAttName(String id, String var, String entry, int acc) throws IOException {
        this.attname_impl.append(Def.TAB3 + "case " + id + ":\n");
        this.attname_impl.append(Def.TAB4 + "return \"" + var + "\"" + Def.SEMICOLON + "\n");
    }

    protected void handleSetVar(String id, String var, String entry, String enumeratiom, int acc) throws IOException {
        this.setVar_impl.append(Def.TAB3 + "case " + id + ":\n" + Def.TAB4);
        if (acc == 67) {
            this.setVar_impl.append(Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOTWRITABLE + ")" + Def.SEMICOLON + "\n");
            return;
        }
        if (acc == 47 || acc == 7) {
            this.setVar_impl.append(Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOTWRITABLE + ")" + Def.SEMICOLON + "\n");
            return;
        }
        String type = SyntaxMapper.getTypeName(entry);
        String meth = SyntaxMapper.getCastMethod(entry);
        this.setVar_impl.append("if (x instanceof " + type + ")" + Def.LBRACE + Def.TAB5);
        if (enumeratiom == null) {
            this.setVar_impl.append(MBEAN_NAME + "." + Def.SET + var + "(((" + type + ")x)." + meth + "())" + Def.SEMICOLON + Def.TAB5 + "return new " + type + "(" + MBEAN_NAME + "." + Def.GET + var + "())" + Def.SEMICOLON + Def.TAB4 + "} else {\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGTYPE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
        } else {
            this.setVar_impl.append("try " + Def.LBRACE + Def.TAB6 + MBEAN_NAME + "." + Def.SET + var + "( new " + enumeratiom + "(((" + type + ")x)." + meth + "()))" + Def.SEMICOLON + Def.TAB5 + Def.N_RBRACE + " catch(" + Def.EXCP_ARGUMENT + " e) " + Def.LBRACE + Def.TAB6 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGVALUE + ")" + Def.SEMICOLON + Def.TAB5 + Def.RBRACE + Def.TAB5 + "return new " + type + "(" + MBEAN_NAME + "." + Def.GET + var + "())" + Def.SEMICOLON + Def.TAB4 + "} else {\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGTYPE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
        }
    }

    protected void handleBuildVal(String id, String var, String entry, String enumeratiom, int acc) throws IOException {
        this.buildval_impl.append(Def.TAB3 + "case " + id + ":\n" + Def.TAB4);
        String type = SyntaxMapper.getTypeName(entry);
        String meth = SyntaxMapper.getCastMethod(entry);
        String jtype = SyntaxMapper.getJavaSyntax(entry);
        if (enumeratiom == null) {
            this.buildval_impl.append("if (x instanceof " + jtype + ")" + Def.LBRACE + Def.TAB5);
            this.buildval_impl.append("return new " + type + "((" + jtype + ")x)" + Def.SEMICOLON + Def.TAB4 + "} else {\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGTYPE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
        } else {
            this.buildval_impl.append("if (x instanceof " + enumeratiom + ")" + Def.LBRACE + Def.TAB5);
            this.buildval_impl.append("try " + Def.LBRACE + Def.TAB6 + "return new " + type + "((" + enumeratiom + ")x)" + Def.SEMICOLON + Def.TAB5 + Def.N_RBRACE + " catch(" + Def.EXCP_ARGUMENT + " e) " + Def.LBRACE + Def.TAB6 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGVALUE + ")" + Def.SEMICOLON + Def.TAB5 + Def.RBRACE + Def.TAB4 + "} else {\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGTYPE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
        }
    }

    protected void handleBuildAtt(String id, String var, String entry, String enumeratiom, int acc) throws IOException {
        this.buildatt_impl.append(Def.TAB3 + "case " + id + ":\n" + Def.TAB4);
        String type = SyntaxMapper.getTypeName(entry);
        String meth = SyntaxMapper.getCastMethod(entry);
        String jtype = SyntaxMapper.getJavaSyntax(entry);
        if (enumeratiom == null) {
            this.buildatt_impl.append("if (x instanceof " + type + ")" + Def.LBRACE + Def.TAB5);
            this.buildatt_impl.append("return ((" + type + ")x)." + meth + "()" + Def.SEMICOLON + Def.TAB4 + "} else {\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGTYPE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
        } else {
            this.buildatt_impl.append("if (x instanceof " + type + ")" + Def.LBRACE + Def.TAB5);
            this.buildatt_impl.append("try " + Def.LBRACE + Def.TAB6 + "return new " + enumeratiom + "(((" + type + ")x)." + meth + "())" + Def.SEMICOLON + Def.TAB5 + Def.N_RBRACE + " catch(" + Def.EXCP_ARGUMENT + " e) " + Def.LBRACE + Def.TAB6 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGVALUE + ")" + Def.SEMICOLON + Def.TAB5 + Def.RBRACE + Def.TAB4 + "} else {\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGTYPE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + "\n");
        }
    }

    protected void handleCheckVar(String id, String var, String entry, String enumeratiom, int acc) throws IOException {
        this.checkVar_impl.append(Def.TAB3 + "case " + id + ":\n" + Def.TAB4);
        if (acc == 67) {
            this.checkVar_impl.append(Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOTWRITABLE + ")" + Def.SEMICOLON + "\n");
            return;
        }
        if (acc == 47 || acc == 7) {
            this.checkVar_impl.append(Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOTWRITABLE + ")" + Def.SEMICOLON + "\n");
            return;
        }
        String type = SyntaxMapper.getTypeName(entry);
        String meth = SyntaxMapper.getCastMethod(entry);
        this.checkVar_impl.append("if (x instanceof " + type + ")" + Def.LBRACE + Def.TAB5);
        if (enumeratiom == null) {
            this.checkVar_impl.append(MBEAN_NAME + "." + Def.CHECK + var + "(((" + type + ")x)." + meth + "())" + Def.SEMICOLON + Def.TAB4 + "} else {\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGTYPE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + Def.TAB4 + "break" + Def.SEMICOLON + "\n");
        } else {
            this.checkVar_impl.append("try " + Def.LBRACE + Def.TAB6 + MBEAN_NAME + "." + Def.CHECK + var + "( new " + enumeratiom + "(((" + type + ")x)." + meth + "()))" + Def.SEMICOLON + Def.TAB5 + Def.N_RBRACE + " catch(" + Def.EXCP_ARGUMENT + " e) " + Def.LBRACE + Def.TAB6 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGVALUE + ")" + Def.SEMICOLON + Def.TAB5 + Def.RBRACE + Def.TAB4 + "} else {\n" + Def.TAB5 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGTYPE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + Def.TAB4 + "break" + Def.SEMICOLON + "\n");
        }
    }

    protected void handleCheckSetAccess(String id, String var, String entry, String enumeratiom, int acc) throws IOException {
        this.checkset_impl.append(Def.TAB3 + "case " + id + ":\n" + Def.TAB4);
        if (acc == 67) {
            this.checkset_impl.append(Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOTWRITABLE + ")" + Def.SEMICOLON + "\n");
            return;
        }
        if (acc == 47 || acc == 7) {
            this.checkset_impl.append(Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOTWRITABLE + ")" + Def.SEMICOLON + "\n");
            return;
        }
        String type = SyntaxMapper.getTypeName(entry);
        this.checkset_impl.append("if (!(x instanceof " + type + "))" + Def.LBRACE + Def.TAB5);
        this.checkset_impl.append(Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_WRONGTYPE + ")" + Def.SEMICOLON + Def.TAB4 + Def.RBRACE + Def.TAB4 + "break" + Def.SEMICOLON + "\n");
    }

    protected void handleCheckGetAccess(String id, String var, String entry, String enumeratiom, int acc) throws IOException {
        this.checkget_impl.append(Def.TAB3 + "case " + id + ":\n" + Def.TAB4);
        if (acc == 47 || acc == 85 || acc == 7) {
            this.checkget_impl.append(Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHINSTANCE + ")" + Def.SEMICOLON + "\n");
            return;
        }
        this.checkget_impl.append("break" + Def.SEMICOLON);
    }

    protected String getParentClassPkg() {
        return Def.PKG_SNMP_MIB_NODE;
    }

    protected String getParentClass() {
        return Def.SNMP_NODE;
    }

    protected String getObjectServerClass() {
        if (this.isStandard()) {
            return Def.SNMP_STANDARD_OSRV;
        }
        if (this.isGeneric()) {
            return Def.SNMP_GENERIC_OSRV;
        }
        return "Object";
    }

    protected String[] getInterfacePkgs() {
        int count = 1;
        if (this.isStandard()) {
            count += 2;
        }
        if (this.isGeneric()) {
            count += 2;
        }
        String[] result = new String[count];
        result[--count] = Def.PKG_SNMP_SUBREQ;
        if (this.isGeneric()) {
            result[--count] = Def.PKG_SNMP_GENERIC_MSRV;
            result[--count] = Def.PKG_SNMP_GENERIC_OSRV;
        }
        if (this.isStandard()) {
            result[--count] = Def.PKG_SNMP_STANDARD_MSRV;
            result[--count] = Def.PKG_SNMP_STANDARD_OSRV;
        }
        return result;
    }

    protected String getInterfaces() {
        StringBuffer itf = new StringBuffer();
        if (this.isStandard()) {
            itf.append(", " + Def.SNMP_STANDARD_MSRV);
        }
        if (this.isGeneric()) {
            itf.append(", " + Def.SNMP_GENERIC_MSRV);
        }
        return itf.toString();
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.meta.comment.desc", this.varName) + "\n" + " * " + MessageHandler.getMessage("generate.mbean.comment.oid", this.oid) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.CLASS + this.symboleName + Def.EXTEND + this.getParentClass() + "\n");
        this.write(Def.TAB + Def.IMPLEMENT + Def.SERIALIZABLE + this.getInterfaces() + Def.LBRACE + "\n");
    }

    protected void writeHeader() throws IOException {
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.writeJmxImports();
        this.write("\n// jdmk imports\n//\n");
        this.writeJdmkImports();
        this.write("\n");
    }

    protected void writeJmxImports() throws IOException {
        this.write(Def.IMPORT + Def.PKG_MBEAN_SERVER + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_COUNTER + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_COUNTER64 + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_GAUGE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_INT + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_UINT + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_IP_ADDR + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_TIME_TICKS + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_OPAQUE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STRING + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STRING_FIXED + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_OID + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_NULL + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_VALUE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_VARBIND + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_STATUS_EXCEPTION + Def.SEMICOLON);
        if (this.isGeneric()) {
            this.write(Def.IMPORT + Def.PKG_OBJECT_NAME + Def.SEMICOLON);
        }
    }

    protected void writeJdmkImports() throws IOException {
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB + Def.SEMICOLON);
        this.write(Def.IMPORT + this.getParentClassPkg() + Def.SEMICOLON);
        String[] intf = this.getInterfacePkgs();
        if (intf != null) {
            for (int i = 0; i < intf.length; ++i) {
                this.write(Def.IMPORT + intf[i] + Def.SEMICOLON);
            }
        }
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB_TABLE + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_ROWSTATUS + Def.SEMICOLON);
        this.write(Def.IMPORT + Def.PKG_SNMP_DEFINITIONS + Def.SEMICOLON);
        if (SyntaxMapper.useUnsigned) {
            this.write(Def.IMPORT + Def.PKG_UNSIGNEDLONG + Def.SEMICOLON);
        }
    }

    protected void handleMinMax(String id) {
    }

    protected void buildConstructorHeader() throws IOException {
        this.constructor.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.constr", this.varName) + "\n" + Def.TAB + " */\n");
        this.constructor.append(Def.TAB + Def.PUBLIC + this.symboleName + "(SnmpMib myMib, " + this.getObjectServerClass() + " objserv)" + Def.LBRACE);
        this.constructor.append(Def.TAB2 + OBJSRV + " = objserv" + Def.SEMICOLON);
    }

    protected void buildIsVariableHeader() throws IOException {
        this.isVariable_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.isvariable", "arc") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + "boolean" + " " + Def.METH_IS_VARIABLE + "(long arc)" + Def.LBRACE + "\n");
    }

    protected void buildIsReadableHeader() throws IOException {
        this.isReadable_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.isreadable", "arc") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + "boolean" + " " + Def.METH_IS_READABLE + "(long arc)" + Def.LBRACE + "\n");
    }

    protected void genAbstractMethodComment(String methname, String classname, StringBuffer result) throws IOException {
        result.append("\n" + Def.TAB + Def.LINE);
        result.append("\n" + Def.TAB + "// ");
        result.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.implements", methname, classname));
        result.append("\n" + Def.TAB + "// " + MessageHandler.getMessage("generate.mib.comment.seedoc", classname));
        result.append("\n" + Def.TAB + "// ");
        result.append("\n" + Def.TAB + Def.LINE + "\n\n");
    }

    protected void buildGetVarHeader() throws IOException {
        this.getVar_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.getvar") + "\n" + Def.TAB + " */\n");
        this.getVar_impl.append(Def.TAB + Def.PUBLIC + Def.SNMP_VALUE + " " + Def.METH_GET_VAR + "(long var, " + Def.SNMP_USERDATA + " data)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.getVar_impl.append(Def.TAB2 + "switch((int)var)" + Def.LBRACE);
    }

    protected void buildSkipVarHeader() throws IOException {
        this.genAbstractMethodComment(Def.METH_SKIP_VARIABLE, this.getParentClass(), this.skipVar_impl);
        this.skipVar_impl.append(Def.TAB + Def.PUBLIC + Def.BOOLEAN + " " + Def.METH_SKIP_VARIABLE + "(long var, " + Def.SNMP_USERDATA + " data, " + "int pduVersion)" + Def.LBRACE);
        this.skipVarBody_impl.append(Def.TAB2 + "switch((int)var)" + Def.LBRACE);
    }

    protected void buildBuildValHeader() throws IOException {
        this.buildval_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.buildval") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.SNMP_VALUE + " " + Def.METH_BUILDVAL + "(long id, Object x)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.buildval_impl.append(Def.TAB2 + "switch((int)id)" + Def.LBRACE);
    }

    protected void buildBuildAttHeader() throws IOException {
        this.buildatt_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.buildatt") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + "Object " + Def.METH_BUILDATT + "(long id, " + Def.SNMP_VALUE + " x)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.buildatt_impl.append(Def.TAB2 + "switch((int)id)" + Def.LBRACE);
    }

    protected void buildGetAttNameHeader() throws IOException {
        this.attname_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.getattname", "id") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + "String " + Def.METH_GET_ATTNAME + "(long id)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.attname_impl.append(Def.TAB2 + "switch((int)id)" + Def.LBRACE);
    }

    protected void buildGet() throws IOException {
        this.genAbstractMethodComment(Def.METH_GET_REQ, this.getParentClass(), this.getReq_impl);
        this.getReq_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_GET_REQ + "(" + Def.SNMP_SUBREQ + " req, " + "int depth)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        if (this.isStandard()) {
            this.getReq_impl.append(Def.TAB2 + OBJSRV + ".get(this,req,depth)" + Def.SEMICOLON);
        } else if (this.isGeneric()) {
            this.getReq_impl.append(Def.TAB2 + OBJSRV + ".get(this,objname,req,depth)" + Def.SEMICOLON);
        }
        this.getReq_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildSetVarHeader() throws IOException {
        this.setVar_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.setvar") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PUBLIC + Def.SNMP_VALUE + " " + Def.METH_SET_VAR + "(" + Def.SNMP_VALUE + " x, long var, " + Def.SNMP_USERDATA + " data)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.setVar_impl.append(Def.TAB2 + "switch((int)var)" + Def.LBRACE);
    }

    protected void buildSet() throws IOException {
        this.genAbstractMethodComment(Def.METH_SET_REQ, this.getParentClass(), this.setReq_impl);
        this.setReq_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_SET_REQ + "(" + Def.SNMP_SUBREQ + " req, " + "int depth)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        if (this.isStandard()) {
            this.setReq_impl.append(Def.TAB2 + OBJSRV + ".set(this,req,depth)" + Def.SEMICOLON);
        } else if (this.isGeneric()) {
            this.setReq_impl.append(Def.TAB2 + OBJSRV + ".set(this,objname,req,depth)" + Def.SEMICOLON);
        }
        this.setReq_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildCheckVarHeader() throws IOException {
        this.checkVar_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.checkvar") + "\n" + Def.TAB + " */\n");
        this.checkVar_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_CHECK_VAR + "(" + Def.SNMP_VALUE + " x, long var, " + Def.SNMP_USERDATA + " data)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.checkVar_impl.append(Def.TAB2 + "switch((int) var)" + Def.LBRACE);
    }

    protected void buildCheckSetAccessHeader() throws IOException {
        this.checkset_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.checkset") + "\n" + Def.TAB + " */\n");
        this.checkset_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_CHECK_SET + "(" + Def.SNMP_VALUE + " x, long id, " + Def.SNMP_USERDATA + " data)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.checkset_impl.append(Def.TAB2 + "switch((int) id)" + Def.LBRACE);
    }

    protected void buildCheckGetAccessHeader() throws IOException {
        this.checkget_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.checkget") + "\n" + Def.TAB + " */\n");
        this.checkget_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_CHECK_GET + "(long id, " + Def.SNMP_USERDATA + " data)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        this.checkget_impl.append(Def.TAB2 + "switch((int) id)" + Def.LBRACE);
    }

    protected void buildCheck() throws IOException {
        this.genAbstractMethodComment(Def.METH_CHECK_REQ, this.getParentClass(), this.checkReq_impl);
        this.checkReq_impl.append(Def.TAB + Def.PUBLIC + Def.VOID + Def.METH_CHECK_REQ + "(" + Def.SNMP_SUBREQ + " req, " + "int depth)\n" + Def.TAB2 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        if (this.isStandard()) {
            this.checkReq_impl.append(Def.TAB2 + OBJSRV + ".check(this,req,depth)" + Def.SEMICOLON);
        } else if (this.isGeneric()) {
            this.checkReq_impl.append(Def.TAB2 + OBJSRV + ".check(this,objname,req,depth)" + Def.SEMICOLON);
        }
        this.checkReq_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeConstructor() throws IOException {
        this.constructor.append(Def.TAB2 + Def.SNMP_VARLIST + " = new int[" + String.valueOf(this.counter) + "]" + Def.SEMICOLON + this.init_impl.toString());
        this.constructor.append(Def.TAB2 + Def.SNMP_NODE + "." + Def.SNMP_SORT + "(" + Def.SNMP_VARLIST + ")" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void defaultGetVarMeth() throws IOException {
        this.getVar_impl.append(Def.TAB4 + "break" + Def.SEMICOLON);
    }

    protected void defaultSkipVarMeth(StringBuffer result) throws IOException {
        result.append(Def.TAB4 + "break" + Def.SEMICOLON);
    }

    protected void defaultBuildValMeth() throws IOException {
        this.buildval_impl.append(Def.TAB4 + "break" + Def.SEMICOLON);
    }

    protected void endBuildValMeth() throws IOException {
        this.buildval_impl.append(Def.TAB2 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHOBJECT + ")" + Def.SEMICOLON);
    }

    protected void defaultBuildAttMeth() throws IOException {
        this.buildatt_impl.append(Def.TAB4 + "break" + Def.SEMICOLON);
    }

    protected void endBuildAttMeth() throws IOException {
        this.buildatt_impl.append(Def.TAB2 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHOBJECT + ")" + Def.SEMICOLON);
    }

    protected boolean skipVarUseSuper() {
        return MibGenProperties.getBooleanProperty("com.sun.jdmk.tools.mibgen.metabeangenerator.skipvar.super", false);
    }

    protected void endSkipVarMeth(StringBuffer result) throws IOException {
        if (this.skipVarUseSuper()) {
            result.append(Def.TAB2 + "return super." + Def.METH_SKIP_VARIABLE + "(var,data,pduVersion)" + Def.SEMICOLON);
        } else {
            result.append(Def.TAB2 + "return false" + Def.SEMICOLON);
        }
    }

    protected void endGetVarMeth() throws IOException {
        this.getVar_impl.append(Def.TAB2 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHOBJECT + ")" + Def.SEMICOLON);
    }

    protected void defaultGetAttNameMeth() throws IOException {
        this.attname_impl.append(Def.TAB4 + "break" + Def.SEMICOLON);
    }

    protected void endGetAttNameMeth() throws IOException {
        this.attname_impl.append(Def.TAB2 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHOBJECT + ")" + Def.SEMICOLON);
    }

    protected void closeGetVarMeth() throws IOException {
        this.getVar_impl.append(Def.TAB3 + "default:\n");
        this.defaultGetVarMeth();
        this.getVar_impl.append(Def.TAB2 + Def.RBRACE);
        this.endGetVarMeth();
        this.getVar_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeSkipVarMeth() throws IOException {
        if (this.totalSkipVarCount > 0) {
            if (this.skipVarCount > 0) {
                this.genSkipVarCode(this.skipVarBody_impl);
                this.skipVarCount = 0;
            }
            this.skipVarBody_impl.append(Def.TAB3 + "default:\n");
            this.defaultSkipVarMeth(this.skipVarBody_impl);
            this.skipVarBody_impl.append(Def.TAB2 + Def.RBRACE);
            this.skipVar_impl.append(this.skipVarBody_impl.toString());
        }
        this.endSkipVarMeth(this.skipVar_impl);
        this.skipVar_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeBuildValMeth() throws IOException {
        this.buildval_impl.append(Def.TAB3 + "default:\n");
        this.defaultBuildValMeth();
        this.buildval_impl.append(Def.TAB2 + Def.RBRACE);
        this.endBuildValMeth();
        this.buildval_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeBuildAttMeth() throws IOException {
        this.buildatt_impl.append(Def.TAB3 + "default:\n");
        this.defaultBuildAttMeth();
        this.buildatt_impl.append(Def.TAB2 + Def.RBRACE);
        this.endBuildAttMeth();
        this.buildatt_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeGetAttNameMeth() throws IOException {
        this.attname_impl.append(Def.TAB3 + "default:\n");
        this.defaultGetAttNameMeth();
        this.attname_impl.append(Def.TAB2 + Def.RBRACE);
        this.endGetAttNameMeth();
        this.attname_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeIsVariableMeth() throws IOException {
        if (this.varCount > 0) {
            this.isVariable_impl.append(Def.TAB2 + "switch((int)arc)" + Def.LBRACE);
            this.isVariable_impl.append((Object)this.isVariableBody_impl);
            this.isVariable_impl.append(Def.TAB4 + "return true" + Def.SEMICOLON);
            this.isVariable_impl.append(Def.TAB3 + "default:\n");
            this.isVariable_impl.append(Def.TAB4 + "break" + Def.SEMICOLON);
            this.isVariable_impl.append(Def.TAB2 + Def.RBRACE);
        }
        this.isVariable_impl.append(Def.TAB2 + "return false" + Def.SEMICOLON);
        this.isVariable_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeIsReadableMeth() throws IOException {
        if (this.readCount > 0) {
            this.isReadable_impl.append(Def.TAB2 + "switch((int)arc)" + Def.LBRACE);
            this.isReadable_impl.append((Object)this.isReadableBody_impl);
            this.isReadable_impl.append(Def.TAB4 + "return true" + Def.SEMICOLON);
            this.isReadable_impl.append(Def.TAB3 + "default:\n");
            this.isReadable_impl.append(Def.TAB4 + "break" + Def.SEMICOLON);
            this.isReadable_impl.append(Def.TAB2 + Def.RBRACE);
        }
        this.isReadable_impl.append(Def.TAB2 + "return false" + Def.SEMICOLON);
        this.isReadable_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void defaultSetVarMeth() throws IOException {
        this.setVar_impl.append(Def.TAB4 + "break" + Def.SEMICOLON);
    }

    protected void endSetVarMeth() throws IOException {
        this.setVar_impl.append(Def.TAB2 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOTWRITABLE + ")" + Def.SEMICOLON);
    }

    protected void closeSetVarMeth() throws IOException {
        this.setVar_impl.append(Def.TAB3 + "default:\n");
        this.defaultSetVarMeth();
        this.setVar_impl.append(Def.TAB2 + Def.RBRACE);
        this.endSetVarMeth();
        this.setVar_impl.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void defaultCheckVarMeth() throws IOException {
        this.checkVar_impl.append(Def.TAB4 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOTWRITABLE + ")" + Def.SEMICOLON);
    }

    protected void closeCheckVarMeth() throws IOException {
        this.checkVar_impl.append(Def.TAB3 + "default:\n");
        this.defaultCheckVarMeth();
        this.checkVar_impl.append(Def.TAB2 + Def.RBRACE + Def.TAB + Def.RBRACE + "\n");
    }

    protected void defaultCheckSetAccessMeth() throws IOException {
        this.checkset_impl.append(Def.TAB4 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOTWRITABLE + ")" + Def.SEMICOLON);
    }

    protected void defaultCheckGetAccessMeth() throws IOException {
        this.checkget_impl.append(Def.TAB4 + Def.THROW_NEW + Def.EXCP_SNMP + "(" + Def.EXCP_SNMP + "." + Def.V_NOSUCHOBJECT + ")" + Def.SEMICOLON);
    }

    protected void closeCheckSetAccessMeth() throws IOException {
        this.checkset_impl.append(Def.TAB3 + "default:\n");
        this.defaultCheckSetAccessMeth();
        this.checkset_impl.append(Def.TAB2 + Def.RBRACE + Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeCheckGetAccessMeth() throws IOException {
        this.checkget_impl.append(Def.TAB3 + "default:\n");
        this.defaultCheckGetAccessMeth();
        this.checkget_impl.append(Def.TAB2 + Def.RBRACE + Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildVarList() throws IOException {
        if (this.isStandard()) {
            this.var_def.append(Def.TAB + Def.PROTECTED + this.prefix + this.varName + Def.MBEANSUFFIX + " node" + Def.SEMICOLON);
        }
        if (this.isGeneric()) {
            this.var_def.append(Def.TAB + Def.PRIVATE + "ObjectName" + " objname = null" + Def.SEMICOLON);
        }
        this.var_def.append(Def.TAB + Def.PROTECTED + this.getObjectServerClass() + " " + OBJSRV + " = null" + Def.SEMICOLON);
    }

    protected void buildSetInstance() throws IOException {
        this.moi_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.setMoi") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PROTECTED + Def.VOID + Def.SET_MOI + "(" + this.prefix + this.varName + Def.MBEANSUFFIX + " var)" + Def.LBRACE + Def.TAB2 + MBEAN_NAME + " = var" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildSetObjectName() throws IOException {
        this.objname_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.setobjname") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PROTECTED + Def.VOID + Def.SET_OBJNAME + "( ObjectName name )" + Def.LBRACE + Def.TAB2 + "objname = name" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    protected void buildSetObjectServer() throws IOException {
        this.objsrv_impl.append(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.meta.comment.table.setobjsrv") + "\n" + Def.TAB + " */\n" + Def.TAB + Def.PROTECTED + Def.VOID + Def.SET_OBJSRV + "(" + this.getObjectServerClass() + " objserver)" + Def.LBRACE + Def.TAB2 + OBJSRV + " = objserver" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }
}

