/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MetaBeanGenerator;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import java.io.IOException;
import java.io.Serializable;

public class MetaEntryGenerator
extends MetaBeanGenerator
implements Serializable {
    protected String rowStatusId = null;
    protected String rowStatusName = null;
    protected int rowStatusAcc = 0;
    protected String rowStatusEnum = null;
    protected String rowStatusSyntax = null;
    protected StringBuffer rs_impl;

    public MetaEntryGenerator(ResourceManager mgr, MibNode aGroup, Context ctxt) throws IOException {
        super(mgr, aGroup, ctxt);
    }

    protected String getParentClass() {
        return Def.SNMP_ENTRY;
    }

    protected String getParentClassPkg() {
        return Def.PKG_SNMP_MIB_ENTRY;
    }

    protected void writeJdmkImports() throws IOException {
        this.write(Def.IMPORT + Def.PKG_SNMP_MIB_NODE + Def.SEMICOLON);
        super.writeJdmkImports();
    }

    protected void handleMinMax(String id) {
    }

    protected void handleVariableId(String id, String var, String entry, String enumtype, int acc) throws IOException {
        super.handleVariableId(id, var, entry, enumtype, acc);
        if (this.isRowStatus(this.context, var)) {
            this.rowStatusId = id;
            this.rowStatusName = var;
            this.rowStatusAcc = acc;
            this.rowStatusEnum = enumtype;
            this.rowStatusSyntax = entry;
        }
    }

    public boolean implementsRowStatus() {
        return this.rowStatusId != null;
    }

    public String getRowStatusId() {
        return this.rowStatusId;
    }

    public String getRowStatusName() {
        return this.rowStatusName;
    }

    public void generateRowStatusCode(Context ctxt, StringBuffer result) {
        if (!this.implementsRowStatus()) {
            return;
        }
        this.genGetRowStatusId(result);
        this.genGetRowStatusName(result);
        this.genMapRowStatus(result);
        this.genGetRowStatus(result);
        this.genSetRowStatus(result);
        this.genIsRowReady(result);
    }

    protected void genIsRowReady(StringBuffer result) {
        result.append("\n" + Def.TAB + Def.PUBLIC + " boolean " + Def.METH_T_ISROWREADY + "(" + Def.SNMP_USERDATA + " userData)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        result.append(Def.TAB2 + "\n");
        result.append(Def.TAB2 + "// " + MessageHandler.getMessage("generate.meta.comment.impl.proposed1") + "\n");
        result.append(Def.TAB2 + "// " + Def.RETURN + "\t(" + Def.METH_T_GETRS + "(userData)" + " != EnumRowStatus.notReady)" + Def.SEMICOLON);
        result.append(Def.TAB2 + "\n");
        result.append(Def.TAB2 + Def.RETURN + "true" + Def.SEMICOLON);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void genGetRowStatusId(StringBuffer result) {
        result.append("\n" + Def.TAB + Def.PUBLIC + " long " + Def.METH_T_GETRSID + "() " + Def.LBRACE);
        result.append(Def.TAB2 + Def.RETURN + this.rowStatusId + Def.SEMICOLON);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void genGetRowStatusName(StringBuffer result) {
        result.append("\n" + Def.TAB + Def.PUBLIC + " String " + Def.METH_T_GETRSNAME + "() " + Def.LBRACE);
        result.append(Def.TAB2 + Def.RETURN + "new String (\"" + this.rowStatusName + "\")" + Def.SEMICOLON);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void genMapRowStatus(StringBuffer result) {
        result.append("\n" + Def.TAB + Def.PROTECTED + " int " + Def.METH_T_MAPRSVALUE + "(" + Def.SNMP_VARBIND + " var, " + Def.SNMP_USERDATA + " userData)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        result.append(Def.TAB2 + Def.FINAL + Def.SNMP_VALUE + " value = var.getSnmpValue()" + Def.SEMICOLON);
        result.append(Def.TAB2 + "if (value == null)\n" + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(\n" + Def.TAB4 + Def.EXCP_SNMP + "." + Def.V_INCONSISTENTVALUE + ")" + Def.SEMICOLON);
        result.append(Def.TAB2 + "if (!(value instanceof " + Def.SNMP_INT + "))\n" + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(\n" + Def.TAB4 + Def.EXCP_SNMP + "." + Def.V_WRONGTYPE + ")" + Def.SEMICOLON);
        result.append(Def.TAB2 + Def.FINAL + "int" + " code = ((" + Def.SNMP_INT + ")value).intValue()" + Def.SEMICOLON);
        result.append(Def.TAB2 + "if (!(" + Def.SNMP_ROWSTATUS + ".isValidValue(code)))\n" + Def.TAB3 + Def.THROW_NEW + Def.EXCP_SNMP + "(\n" + Def.TAB4 + Def.EXCP_SNMP + "." + Def.V_INCONSISTENTVALUE + ")" + Def.SEMICOLON);
        result.append(Def.TAB2 + Def.RETURN + " code" + Def.SEMICOLON);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void genSetRowStatus(StringBuffer result) {
        result.append("\n" + Def.TAB + Def.PUBLIC + " SnmpValue " + Def.METH_T_SETRS + "(int status, " + Def.SNMP_USERDATA + " userData)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        result.append(Def.TAB2 + Def.FINAL + " " + Def.SNMP_INT + " x = new " + Def.SNMP_INT + "(status)" + Def.SEMICOLON);
        if (this.isStandard()) {
            result.append(Def.TAB2 + Def.RETURN + " " + Def.METH_SET_VAR + "(x, " + this.rowStatusId + ", userData)" + Def.SEMICOLON);
        }
        if (this.isGeneric()) {
            result.append(Def.TAB2 + Def.RETURN + " " + OBJSRV + ".set(this, objname, x, " + this.rowStatusId + ", userData)" + Def.SEMICOLON);
        }
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void genGetRowStatus(StringBuffer result) {
        result.append("\n" + Def.TAB + Def.PUBLIC + " int " + Def.METH_T_GETRS + "(" + Def.SNMP_USERDATA + " userData)\n" + Def.TAB3 + Def.THROWS + Def.EXCP_SNMP + Def.LBRACE);
        if (this.isStandard()) {
            result.append(Def.TAB2 + Def.FINAL + " " + Def.SNMP_VALUE + " x = " + Def.METH_GET_VAR + "(" + this.rowStatusId + ", userData)" + Def.SEMICOLON);
        }
        if (this.isGeneric()) {
            result.append(Def.TAB2 + Def.FINAL + " " + Def.SNMP_VALUE + " x = " + OBJSRV + ".get(this, objname, " + this.rowStatusId + ", userData)" + Def.SEMICOLON);
        }
        result.append(Def.TAB2 + Def.FINAL + " " + Def.SNMP_VARBIND + " vb = new " + Def.SNMP_VARBIND + "()" + Def.SEMICOLON);
        result.append("\n" + Def.TAB2 + "// " + MessageHandler.getMessage("generate.meta.comment.impl.proposed2") + "\n");
        result.append(Def.TAB2 + "//\n");
        result.append(Def.TAB2 + "// vb.oid = new " + Def.SNMP_OID + "(\"" + this.oid + "." + this.rowStatusId + "\")" + Def.SEMICOLON + "\n");
        result.append(Def.TAB2 + "vb.setSnmpValue(x)" + Def.SEMICOLON);
        result.append(Def.TAB2 + Def.RETURN + Def.METH_T_MAPRSVALUE + "(vb, userData)" + Def.SEMICOLON);
        result.append(Def.TAB + Def.RBRACE + "\n");
    }

    protected void closeMethods() throws IOException {
        this.generateRowStatusCode(this.context, this.rs_impl);
        super.closeMethods();
    }

    protected void writeMethods() throws IOException {
        super.writeMethods();
        this.write(this.rs_impl.toString());
    }

    protected void initBuffers() {
        super.initBuffers();
        this.rs_impl = new StringBuffer();
    }
}

