/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public class MibGenProperties {
    private static String MIBGEN_RESOURCE_NAME = "com/sun/jdmk/tools/mibgen/mibgen.properties";
    public static String MIBGEN_RESOURCE_NAME_JDMK50 = "com/sun/jdmk/tools/mibgen/mibgen.properties.jdmk50";
    public static final String CONFIG_RESOURCE = "com.sun.jdmk.tools.mibgen.config.resource";
    public static final String CONFIG_FILE = "com.sun.jdmk.tools.mibgen.config.file";
    public static final String OPTION_USE_DISPLAY_HINT = "com.sun.jdmk.tools.mibgen.options.use.display.hint";
    public static final String OPTION_MBEAN_TABLE_ACCESSOR = "com.sun.jdmk.tools.mibgen.options.mbean.table.accessor";
    public static final String OPTION_MBEAN_AFN_GETTER = "com.sun.jdmk.tools.mibgen.options.mbean.notification.data.getter";
    public static final String OPTION_MIB_FACTORY_ABSTRACT = "com.sun.jdmk.tools.mibgen.options.mib.factory.abstract";
    public static final String GEN_METABEAN_SKIPVAR_SUP = "com.sun.jdmk.tools.mibgen.metabeangenerator.skipvar.super";
    public static final String PKG_SNMP_DEFINITIONS = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpDefinitions";
    public static final String PKG_SNMP_COUNTER = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpCounter";
    public static final String PKG_SNMP_COUNTER64 = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpCounter64";
    public static final String PKG_SNMP_GAUGE = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpGauge";
    public static final String PKG_SNMP_INT = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpInt";
    public static final String PKG_SNMP_UINT = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpUnsignedInt";
    public static final String PKG_SNMP_IP_ADDR = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpIpAddress";
    public static final String PKG_SNMP_TIME_TICKS = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpTimeticks";
    public static final String PKG_SNMP_OPAQUE = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpOpaque";
    public static final String PKG_SNMP_STRING = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpString";
    public static final String PKG_SNMP_STRING_FIXED = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpStringFixed";
    public static final String PKG_SNMP_OID = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpOid";
    public static final String PKG_SNMP_NULL = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpNull";
    public static final String PKG_SNMP_VALUE = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpValue";
    public static final String PKG_SNMP_VARBIND = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpVarBind";
    public static final String PKG_SNMP_OID_RECORD = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpOidRecord";
    public static final String PKG_SNMP_STATUS_EXCEPTION = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpStatusException";
    public static final String PKG_ENUMERATED = "com.sun.jdmk.tools.mibgen.fullclassnames.Enumerated";
    public static final String PKG_SNMP_SUBREQ = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpMibSubRequest";
    public static final String PKG_SNMP_INDEX = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpIndex";
    public static final String PKG_SNMP_MIB = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpMib";
    public static final String PKG_SNMP_MIB_NODE = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpMibNode";
    public static final String PKG_SNMP_MIB_GROUP = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpMibGroup";
    public static final String PKG_SNMP_MIB_ENTRY = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpMibEntry";
    public static final String PKG_SNMP_MIB_TABLE = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpMibTable";
    public static final String PKG_SNMP_OID_TABLE_SUPPORT = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpOidTableSupport";
    public static final String PKG_SNMP_TABLE = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpMibTable";
    public static final String PKG_SNMP_TABLE_SUPPORT = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpTableSupport";
    public static final String PKG_SNMP_ENTRY_FACTORY = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpTableEntryFactory";
    public static final String PKG_SNMP_TABLE_CB = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpTableCallbackHandler";
    public static final String PKG_SNMP_STANDARD_MSRV = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpStandardMetaServer";
    public static final String PKG_SNMP_STANDARD_OSRV = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpStandardObjectServer";
    public static final String PKG_SNMP_GENERIC_MSRV = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpGenericMetaServer";
    public static final String PKG_SNMP_GENERIC_OSRV = "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpGenericObjectServer";
    public static final String PKG_SNMP_ROWSTATUS = "com.sun.jdmk.tools.mibgen.fullclassnames.EnumRowStatus";
    public static String PKG_UNSIGNEDLONG = "com.sun.jdmk.tools.mibgen.fullclassnames.UnsignedLong";
    static Properties properties = null;

    private static void setDefault(Properties p, String name, String value) {
        p.put(name, System.getProperty(name, value));
    }

    private static Properties makedefaults() {
        Properties p = new Properties();
        MibGenProperties.setDefault(p, OPTION_MIB_FACTORY_ABSTRACT, "false");
        MibGenProperties.setDefault(p, OPTION_MBEAN_TABLE_ACCESSOR, "true");
        MibGenProperties.setDefault(p, OPTION_USE_DISPLAY_HINT, "false");
        MibGenProperties.setDefault(p, GEN_METABEAN_SKIPVAR_SUP, "false");
        MibGenProperties.setDefault(p, PKG_SNMP_DEFINITIONS, "com.sun.management.snmp.SnmpDefinitions");
        MibGenProperties.setDefault(p, PKG_SNMP_COUNTER, "com.sun.management.snmp.SnmpCounter");
        MibGenProperties.setDefault(p, PKG_SNMP_COUNTER64, "com.sun.management.snmp.SnmpCounter64");
        MibGenProperties.setDefault(p, PKG_SNMP_GAUGE, "com.sun.management.snmp.SnmpGauge");
        MibGenProperties.setDefault(p, PKG_SNMP_INT, "com.sun.management.snmp.SnmpInt");
        MibGenProperties.setDefault(p, PKG_SNMP_UINT, "com.sun.management.snmp.SnmpUnsignedInt");
        MibGenProperties.setDefault(p, PKG_SNMP_IP_ADDR, "com.sun.management.snmp.SnmpIpAddress");
        MibGenProperties.setDefault(p, PKG_SNMP_TIME_TICKS, "com.sun.management.snmp.SnmpTimeticks");
        MibGenProperties.setDefault(p, PKG_SNMP_OPAQUE, "com.sun.management.snmp.SnmpOpaque");
        MibGenProperties.setDefault(p, PKG_SNMP_STRING, "com.sun.management.snmp.SnmpString");
        MibGenProperties.setDefault(p, PKG_SNMP_STRING_FIXED, "com.sun.management.snmp.SnmpStringFixed");
        MibGenProperties.setDefault(p, PKG_SNMP_OID, "com.sun.management.snmp.SnmpOid");
        MibGenProperties.setDefault(p, PKG_SNMP_NULL, "com.sun.management.snmp.SnmpNull");
        MibGenProperties.setDefault(p, PKG_SNMP_VALUE, "com.sun.management.snmp.SnmpValue");
        MibGenProperties.setDefault(p, PKG_SNMP_VARBIND, "com.sun.management.snmp.SnmpVarBind");
        MibGenProperties.setDefault(p, PKG_SNMP_OID_RECORD, "com.sun.management.snmp.SnmpOidRecord");
        MibGenProperties.setDefault(p, PKG_SNMP_STATUS_EXCEPTION, "com.sun.management.snmp.SnmpStatusException");
        MibGenProperties.setDefault(p, PKG_ENUMERATED, "com.sun.jdmk.Enumerated");
        MibGenProperties.setDefault(p, PKG_SNMP_SUBREQ, "com.sun.management.snmp.agent.SnmpMibSubRequest");
        MibGenProperties.setDefault(p, PKG_SNMP_INDEX, "com.sun.management.snmp.agent.SnmpIndex");
        MibGenProperties.setDefault(p, PKG_SNMP_MIB, "com.sun.management.snmp.agent.SnmpMib");
        MibGenProperties.setDefault(p, PKG_SNMP_MIB_NODE, "com.sun.management.snmp.agent.SnmpMibNode");
        MibGenProperties.setDefault(p, PKG_SNMP_MIB_GROUP, "com.sun.management.snmp.agent.SnmpMibGroup");
        MibGenProperties.setDefault(p, PKG_SNMP_MIB_ENTRY, "com.sun.management.snmp.agent.SnmpMibEntry");
        MibGenProperties.setDefault(p, "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpMibTable", "com.sun.management.snmp.agent.SnmpMibTable");
        MibGenProperties.setDefault(p, PKG_SNMP_OID_TABLE_SUPPORT, "com.sun.management.snmp.SnmpOidTableSupport");
        MibGenProperties.setDefault(p, "com.sun.jdmk.tools.mibgen.fullclassnames.SnmpMibTable", "com.sun.management.snmp.agent.SnmpMibTable");
        MibGenProperties.setDefault(p, PKG_SNMP_TABLE_SUPPORT, "com.sun.management.snmp.agent.SnmpTableSupport");
        MibGenProperties.setDefault(p, PKG_SNMP_ENTRY_FACTORY, "com.sun.management.snmp.agent.SnmpTableEntryFactory");
        MibGenProperties.setDefault(p, PKG_SNMP_TABLE_CB, "com.sun.management.snmp.agent.SnmpTableCallbackHandler");
        MibGenProperties.setDefault(p, PKG_SNMP_STANDARD_MSRV, "com.sun.management.snmp.agent.SnmpStandardMetaServer");
        MibGenProperties.setDefault(p, PKG_SNMP_STANDARD_OSRV, "com.sun.management.snmp.agent.SnmpStandardObjectServer");
        MibGenProperties.setDefault(p, PKG_SNMP_GENERIC_MSRV, "com.sun.management.snmp.agent.SnmpGenericMetaServer");
        MibGenProperties.setDefault(p, PKG_SNMP_GENERIC_OSRV, "com.sun.management.snmp.agent.SnmpGenericObjectServer");
        MibGenProperties.setDefault(p, PKG_SNMP_ROWSTATUS, "com.sun.management.snmp.EnumRowStatus");
        MibGenProperties.setDefault(p, PKG_UNSIGNEDLONG, "com.sun.jdmk.UnsignedLong");
        return p;
    }

    private static Properties load() {
        Properties p = MibGenProperties.makedefaults();
        Properties result = new Properties(p);
        Properties resource = new Properties();
        try {
            InputStream in;
            String filename = System.getProperty(CONFIG_FILE);
            if (filename != null) {
                in = new FileInputStream(filename);
            } else {
                String resourceName = System.getProperty(CONFIG_RESOURCE);
                if (resourceName == null) {
                    resourceName = MIBGEN_RESOURCE_NAME;
                }
                ClassLoader mycl = MibGenProperties.class.getClassLoader();
                ClassLoader loader = mycl == null ? ClassLoader.getSystemClassLoader() : mycl;
                in = loader.getResourceAsStream(resourceName);
            }
            if (in == null) {
                return result;
            }
            resource.load(in);
            Enumeration<Object> e = resource.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = resource.getProperty(name);
                MibGenProperties.setDefault(result, name, value);
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        return result;
    }

    public static boolean isDeprecatedEnabled() {
        return !"com.sun.management.snmp.EnumRowStatus".equals(MibGenProperties.getProperty(PKG_SNMP_ROWSTATUS));
    }

    public static boolean useDisplayHint() {
        return MibGenProperties.getBooleanProperty(OPTION_USE_DISPLAY_HINT, "false");
    }

    private static synchronized Properties properties() {
        if (properties == null) {
            properties = MibGenProperties.load();
        }
        return properties;
    }

    public static synchronized void define(String property) throws IllegalArgumentException {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(property.getBytes());
            MibGenProperties.properties().load(is);
        }
        catch (Exception x) {
            throw new IllegalArgumentException(property);
        }
    }

    public static synchronized void setProperty(String name, String value) {
        MibGenProperties.properties().setProperty(name, value);
    }

    public static Properties getProperties() {
        return new Properties(MibGenProperties.properties());
    }

    public static String getProperty(String name) {
        return MibGenProperties.properties().getProperty(name);
    }

    public static String getProperty(String name, String defval) {
        return MibGenProperties.properties().getProperty(name, defval);
    }

    public static boolean getBooleanProperty(String name, boolean defval) {
        String val = MibGenProperties.properties().getProperty(name);
        if (val == null) {
            return defval;
        }
        return MibGenProperties.booleanProperty(val);
    }

    public static boolean getBooleanProperty(String name, String defval) {
        String val = MibGenProperties.properties().getProperty(name, defval);
        return MibGenProperties.booleanProperty(val);
    }

    public static boolean booleanProperty(String val) {
        return Boolean.valueOf(val);
    }

    public static void store(String filename) throws IOException {
        MibGenProperties.store(MibGenProperties.getProperties(), filename);
    }

    public static void store(Properties p, String filename) throws IOException {
        Properties store = new Properties();
        if (p != null) {
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                store.setProperty(name, p.getProperty(name));
            }
        }
        store.store(new FileOutputStream(filename), "mibgen.properties");
    }
}

