/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.tools.mibgen;

import com.sun.jdmk.tools.mibgen.ASTMib;
import com.sun.jdmk.tools.mibgen.ASTNamedType;
import com.sun.jdmk.tools.mibgen.ASTObjectTypeDefinition;
import com.sun.jdmk.tools.mibgen.Context;
import com.sun.jdmk.tools.mibgen.Def;
import com.sun.jdmk.tools.mibgen.Generator;
import com.sun.jdmk.tools.mibgen.MessageHandler;
import com.sun.jdmk.tools.mibgen.MibNode;
import com.sun.jdmk.tools.mibgen.RegisteredObject;
import com.sun.jdmk.tools.mibgen.ResourceManager;
import com.sun.jdmk.tools.mibgen.SyntaxMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class MibStoreGenerator
extends Generator
implements Serializable {
    protected String module = "";
    protected String fileName = "";
    protected StringBuffer metadata = new StringBuffer();
    protected boolean entrySet = false;
    private String varName = "varList";

    public MibStoreGenerator(ResourceManager mgr, ASTMib aMib, Context ctxt) throws IOException {
        super(mgr, ctxt);
        this.mib = aMib;
        this.context.mib = aMib;
        this.module = aMib.getModuleName();
        this.fileName = this.prefix + this.translateMibName() + Def.OIDTABLESUFFIX;
        this.out = this.openFile(this.fileName + Def.JAVA);
        this.writeHeader();
        this.writeClassDeclaration();
        this.writeConstructor();
    }

    public void setContext(Context ctxt) {
        super.setContext(ctxt);
        this.mib = ctxt.mib;
    }

    private void generateSymbolCode(ASTMib mib) throws IOException {
        if (mib.registrationTable == null) {
            return;
        }
        Enumeration keys = mib.registrationTable.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            RegisteredObject obj = (RegisteredObject)mib.registrationTable.get(key);
            switch (obj.getNodeType()) {
                case 2: {
                    this.addMibEntry(key, mib.resolveOidSymbol(key), SyntaxMapper.MibStoreIdentitySymbol);
                    break;
                }
                case 4: {
                    this.addMibEntry(key, mib.resolveOidSymbol(key), SyntaxMapper.MibStoreObjectGroupSymbol);
                    break;
                }
                case 5: {
                    this.addMibEntry(key, mib.resolveOidSymbol(key), SyntaxMapper.MibStoreNotificationGroupSymbol);
                    break;
                }
                case 3: {
                    this.addMibEntry(key, mib.resolveOidSymbol(key), SyntaxMapper.MibStoreNotificationSymbol);
                    break;
                }
            }
        }
    }

    public void generateCode() throws IOException {
        this.initMeta();
        MibNode node = this.mib.getMibTree().getRoot();
        this.generateCode(node);
        this.generateSymbolCode(this.mib);
        this.endCodeGeneration();
    }

    private void endCodeGeneration() throws IOException {
        if (this.entrySet) {
            this.closeMeta();
        } else {
            this.closeMeta();
        }
        this.write(this.metadata.toString());
        this.write(Def.RBRACE);
        this.closeIO();
    }

    private void generateCode(MibNode node) throws IOException {
        if (node.isAssociated()) {
            MibNode child;
            Enumeration e;
            Hashtable children;
            String oid = node.getComputedOid();
            String syntax = SyntaxMapper.getMibStoreSyntax(SyntaxMapper.getTypeName(this.accessNodeSyntax(node)));
            if (syntax.equals(SyntaxMapper.MibStoreSequenceSymbol) && !(children = node.getChildren()).isEmpty() && (e = children.elements()).hasMoreElements() && (child = (MibNode)e.nextElement()).getChildren().isEmpty()) {
                syntax = SyntaxMapper.MibStoreEntrySymbol;
            }
            this.addMibEntry(node.getRealSymbolName(), oid, syntax);
        }
        Hashtable children = node.getChildren();
        Enumeration e = children.elements();
        while (e.hasMoreElements()) {
            this.generateCode((MibNode)e.nextElement());
        }
    }

    protected void addMibEntry(String name, String oid, String syntax) throws IOException {
        if (this.entrySet) {
            this.metadata.append(",\n");
        }
        this.metadata.append(Def.TAB2 + "new SnmpOidRecord(\"" + name + "\", \"" + oid + "\", \"" + syntax + "\")");
        this.entrySet = true;
    }

    protected void closeMeta() throws IOException {
        this.metadata.append(Def.TAB + "};\n");
    }

    protected void initMeta() throws IOException {
        this.metadata.append(Def.TAB + "static SnmpOidRecord " + this.varName + " [] = {\n");
    }

    protected void writeClassDeclaration() throws IOException {
        this.write("/**\n * " + MessageHandler.getMessage("generate.miboidtable.comment.header", this.module) + "\n" + " * " + MessageHandler.getMessage("generate.miboidtable.comment.header2", this.fileName) + "\n" + " */\n");
        this.write(Def.PUBLIC + Def.CLASS + this.fileName + Def.EXTEND + Def.SNMP_OID_TABLE + Def.IMPLEMENT + Def.SERIALIZABLE + Def.LBRACE + "\n");
    }

    protected void writeVersion() throws IOException {
        String msgid = "generate.version";
        this.write("\n//\n// " + MessageHandler.getMessage(msgid, this.mib.getModuleName()) + "\n//\n\n");
    }

    protected void writeHeader() throws IOException {
        this.writePkg();
        this.write("// java imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SERIALIZABLE + Def.SEMICOLON);
        this.write("\n// jmx imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SNMP_OID_RECORD + Def.SEMICOLON);
        if (SyntaxMapper.useUnsigned) {
            this.write(Def.IMPORT + Def.PKG_UNSIGNEDLONG + Def.SEMICOLON);
        }
        this.write("\n// jdmk imports\n//\n");
        this.write(Def.IMPORT + Def.PKG_SNMP_OID_TABLE_SUPPORT + Def.SEMICOLON);
        this.write("\n");
    }

    protected void writeConstructor() throws IOException {
        this.write(Def.TAB + "/**\n" + Def.TAB + " * " + MessageHandler.getMessage("generate.mib.comment.const") + "\n" + Def.TAB + " */\n");
        this.write(Def.TAB + Def.PUBLIC + this.fileName + "()" + Def.LBRACE + Def.TAB2 + "super(\"" + this.translateMibName() + "\")" + Def.SEMICOLON + Def.TAB2 + "loadMib(" + this.varName + ")" + Def.SEMICOLON + Def.TAB + Def.RBRACE + "\n");
    }

    private String translateMibName() throws IOException {
        String result = this.module.trim();
        result = result.replace('-', '_');
        result = result.replace('.', '_');
        result = result.replace(',', '_');
        result = result.replace(',', '_');
        result = result.replace(' ', '_');
        return result;
    }

    private String accessNodeSyntax(MibNode node) {
        ASTObjectTypeDefinition definition = node.getObjectType();
        ASTNamedType syntaxObject = definition.getSyntax();
        return syntaxObject.getSnmpSyntax();
    }
}

