/*
 * This file is part of the DistSim distributed simulation framework (hibernate-extension)
 * Copyright (C) 2007 Ulf Hermann; 2003-2006 Doug Currie, doug.currie@alum.mit.edu and others
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package brn.distsim.ormapper.class2hbm;

/**
 * @version 1.x
 * @author <a href="mailto:doug.currie@alum.mit.edu">e</a>
 * @auther <a href="mailto:uhermann@informatik.hu-berlin.de">Ulf Hermann</a>
 */
class ReflectedListProperty extends ReflectedProperty {

	/**
	 * Constructor for ReflectedListProperty.
	 * 
	 * @param name
	 * @param type
	 */
	ReflectedListProperty(String name, Class type, MapGenerator map,
			String className) {
		super(name, type, map, "list", className, true);
	}

	protected void getXMLinArray(int level, StringBuffer buf) {
		this.buf = buf;
		emitSubCollectionStr(level, name);
	}

	protected void getXMLinComposite(int level, StringBuffer buf) {
		this.buf = buf;
		emitCollectionInCompositeStr(level);
	}

	protected void getXML(int level, StringBuffer buf) {
		this.buf = buf;
		emitCollectionStrL(level, "list", name, false, false);
		emitCollectionStrK(level + 1, "uid");
		emitCollectionStrI(level + 1, "i");
		emitCollectionStrE(level + 1, "elm");
		emitCollectionStrR(level, "list");
	}
}
