/*
 * This file is part of the DistSim distributed simulation framework (hibernate-extension)
 * Copyright (C) 2007 Ulf Hermann; 2003-2006 Doug Currie, doug.currie@alum.mit.edu and others
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package brn.distsim.ormapper.util;

import java.util.Iterator;

import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;

/**
 * force cascade delete on ALL foreign keys. (this is evil, but the only way to
 * ensure that results can be deleted again)
 * 
 * @author alve
 * 
 */
public class CascadeConfiguration extends Configuration {

	private static final long serialVersionUID = 8751112145259512481L;

	/**
	 * Generate DDL for creating tables
	 * 
	 * @see org.hibernate.tool.hbm2ddl.SchemaExport
	 */
	public String[] generateSchemaCreationScript(Dialect dialect)
			throws HibernateException {
		Iterator iter = getTableMappings();
		while (iter.hasNext()) {
			Table table = (Table) iter.next();
			if (table.isPhysicalTable()) {
				Iterator subIter = table.getForeignKeyIterator();
				while (subIter.hasNext()) {
					ForeignKey fk = (ForeignKey) subIter.next();
					if (fk.isPhysicalConstraint())
						fk.setCascadeDeleteEnabled(true);
				}
			}
		}
		return super.generateSchemaCreationScript(dialect);
	}
}