/*
 * This file is part of the DistSim distributed simulation framework (hibernate-extension)
 * Copyright (C) 2007 Ulf Hermann; 2003-2006 Doug Currie, doug.currie@alum.mit.edu and others
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package brn.distsim.ormapper.util;

import org.hibernate.PropertyNotFoundException;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;

public class ConstantFieldAccessor implements PropertyAccessor {

	private EntityResolver entityResolver = new EntityResolver();
	private SubclassResolver subclassResolver = new SubclassResolver();
	private SimulationIdResolver simulationIdResolver = new SimulationIdResolver();
	
	public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
		if (propertyName.equals("entity")) return entityResolver;
		else if (propertyName.equals("subclass")) return subclassResolver;
		else if (propertyName.equals("simulationId")) return simulationIdResolver;
		else throw (new PropertyNotFoundException("you can only use this ConstantFieldAccessor with entity, simulationId or subclass."));
	}

	public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
		if (propertyName.equals("entity")) return entityResolver;
		else if (propertyName.equals("subclass")) return subclassResolver;
		else if (propertyName.equals("simulationId")) return simulationIdResolver;
		else throw (new PropertyNotFoundException("you can only use this ConstantFieldAccessor with entity, simulationId or subclass."));
	}

}
