/*
 * This file is part of the DistSim distributed simulation framework (hibernate-extension)
 * Copyright (C) 2007 Ulf Hermann; 2003-2006 Doug Currie, doug.currie@alum.mit.edu and others
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package brn.distsim.ormapper.util;

import java.lang.reflect.Method;
import java.util.Map;

import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;

public class EntityResolver implements Getter, Setter {
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -1029609122660693830L;
	private static String entity = "";
	
	public static void setEntity (String newEntity) {
		entity = newEntity;
	}
	
	public Object get(Object owner) throws HibernateException {
		return entity;
	}

	public Object getForInsert(Object owner, Map mergeMap,
			SessionImplementor session) throws HibernateException {
		return entity;
	}

	public Class getReturnType() {
		return String.class;
	}

	public String getMethodName() {
		return null;
	}

	public Method getMethod() {
		return null;
	}

	public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
		// do nothing		
	}

}
