/*
 * This file is part of the DistSim distributed simulation framework (hibernate-extension)
 * Copyright (C) 2007 Ulf Hermann; 2003-2006 Doug Currie, doug.currie@alum.mit.edu and others
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package brn.distsim.ormapper.util;

import java.lang.reflect.Method;
import java.util.Map;

import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;

public class SimulationIdResolver implements Setter, Getter {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8942950105997363607L;
	private static Integer simulationId = new Integer(0);
	
	public static void setSimulationId(int id) {
		simulationId = new Integer(id);
	}
	
	public void set(Object target, Object value,
			SessionFactoryImplementor factory) throws HibernateException {
		// nothing
	}

	public String getMethodName() {
		return null;
	}

	public Method getMethod() {
		return null;
	}

	public Object get(Object owner) throws HibernateException {
		return simulationId;
	}

	public Object getForInsert(Object owner, Map mergeMap,
			SessionImplementor session) throws HibernateException {
		return simulationId;
	}

	public Class getReturnType() {
		return Integer.class;
	}

}
