/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.UnsupportedLookAndFeelException;

import brn.distsim.client.ui.ClientFrame;


public class Client {

	private static final long serialVersionUID = -8164888561774416467L;

	private ClientFrame frame;

	public ClientFrame getFrame() {
		return frame;
	}

	public Client() {
		frame = new ClientFrame();
		new DBConnector(this);
	}

	/**
	 * Create the GUI and show it. For thread safety, this method should be
	 * invoked from the event-dispatching thread.
	 */
	private static void createAndShowGUI() {
		Client client = new Client();
		ClientFrame frame = client.getFrame();
		frame.pack();
		frame.setVisible(true);
		Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
		size.height *= 3.0/4.0;
		size.width *= 3.0/4.0;
		frame.setSize(size);
	}

	public static void main(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
		//UIManager.setLookAndFeel(
	        //   UIManager.getSystemLookAndFeelClassName());
		// Schedule a job for the event-dispatching thread:
		// creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}

}
