/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.data;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * this class represents properties consisting of name and value that are backed
 * by the database and don't have any further dependent objects
 *
 * @author alve
 *
 * @param <E>
 */
public abstract class DbBackedProperties<E extends DbBackedProperties.Property>
		extends DbBackedEntries<E> {

	public abstract class Property extends DbBackedEntries.Entry {

		protected String value;

		public Property(String name, String value) {
			super(name);
			this.value = value;
		}

		public String getValue() {
			return value;
		}
	}

	public DbBackedProperties(Connection definitions, int id) {
		super(definitions, id);
	}

	public DbBackedProperties(DbBackedProperties<E> other) {
		super(other);
	}

	public DbBackedProperties(Connection db, int id, ResultSet set)
			throws SQLException {
		super(db, id, set);
	}

	/**
	 * convenience method for get(name).getValue();
	 *
	 * @param name
	 * @return convenience method for get(name).getValue();
	 */
	public String getValue(String name) {
		E entry = entries.get(name);
		if (entry == null)
			return null;
		else
			return entry.getValue();
	}
}
