/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.data;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class GroupNumericParameters extends
		DbBackedEntries<GroupNumericParameters.Parameter> {

	public static String TABLE_NAME = "group_numeric_params";

	public GroupNumericParameters(Connection definitions, int id) {
		super(definitions, id);
	}

	public GroupNumericParameters(GroupNumericParameters other) {
		super(other);
	}

	public GroupNumericParameters(Connection db, int id, ResultSet set)
			throws SQLException {
		super(db, id, set);
	}

	public class Parameter extends DbBackedEntries.Entry {

		protected String min;

		protected String max;

		protected String step;

		public Parameter(String name, String min, String max, String step) {
			super(name);
			this.min = min;
			this.max = max;
			this.step = step;
		}

		public String getMin() {
			return min;
		}

		public String getMax() {
			return max;
		}

		public String getStep() {
			return step;
		}

		public void performDbInsert(int groupId) throws SQLException {
			id = groupId;
			statement.execute("INSERT INTO " + TABLE_NAME + " VALUES ('" + id
					+ "', '" + name + "', '" + min + "', '" + max + "', '"
					+ step + "');");
		}

		public void performDbDelete() throws SQLException {
			statement.execute("DELETE FROM " + TABLE_NAME + " WHERE groupId='"
					+ id + "' AND name='" + name + "';");
		}

		public void performDbUpdate() throws SQLException {
			statement.execute("REPLACE INTO " + TABLE_NAME + " VALUES ('" + id
					+ "', '" + name + "', '" + min + "', '" + max + "', '"
					+ step + "');");
		}
	}

	@Override
	public Parameter getEmptyDependent() {
		return new Parameter(null, null, null, null);
	}

	@Override
	public Parameter getDependent(ResultSet data) throws SQLException {
		return new Parameter(data.getString("name"), data.getString("min"),
				data.getString("max"), data.getString("step"));
	}

	@Override
	public Parameter getDependent(Parameter other) {
		return new Parameter(other.name, other.min, other.max, other.step);
	}
	

	@Override
	public void loadFromDb() throws SQLException {
		ResultSet params = statement.executeQuery("SELECT * FROM " + TABLE_NAME
				+ " WHERE groupId=" + id + ";");
		super.loadFromDb(params);
	}

	public static List<String> getNames(Connection db, int studyId)
			throws SQLException {
		ResultSet names = db
				.createStatement()
				.executeQuery(
						"SELECT DISTINCT name FROM "
								+ TABLE_NAME
								+ " WHERE groupId in (SELECT id FROM groups WHERE studyId="
								+ studyId + ") ORDER BY name;");
		return namesToList(names);
	}
}
