/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.data;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;

public class Progress {

	private Timestamp started;

	private Timestamp expectedEnd;

	private int percentageDone;

	private int simulationId;
	
	private String state;

	private Statement statement;

	public void loadFromDb() throws SQLException {
		ResultSet progress = statement
				.executeQuery("SELECT * FROM progress WHERE simulationId = "
						+ simulationId + ";");
		if (progress.next()) {
			// sql exception is thrown from getTimestamp if the timestamp is 0
			// this is a dirty workaround.
			try {
				started = progress.getTimestamp("started");
			} catch (SQLException e) {
				started = null;
			} try {
				expectedEnd = progress.getTimestamp("expectedEnd");
			} catch (SQLException e) {
				expectedEnd = null;
			}
			percentageDone = progress.getInt("percentageDone");
			simulationId = progress.getInt("simulationId");
			state = progress.getString("state");
		}
	}

	public Progress(Connection results, int id) throws SQLException {
		simulationId = id;
		statement = results.createStatement();
	}

	public Timestamp getStarted() {
		return started;
	}
	
	public Timestamp getExpectedEnd() {
		return expectedEnd;
	}

	public int getPercentageDone() {
		return percentageDone;
	}

	public Object getState() {
		return state;
	}
}
