/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.data;

import java.sql.SQLException;

/**
 * This interface represents an object that can be saved, inserted and updated
 * in the database. Also it must have some kind of name.
 * 
 * @author alve
 * 
 */

public interface Saveable {
	/**
	 * update the object's representation in the database, using the state of
	 * the object
	 * 
	 * @throws SQLException
	 *             if the query fails
	 */
	public void performDbUpdate() throws SQLException;

	/**
	 * delete the object's representation from the database
	 * 
	 * @throws SQLException
	 *             if the query fails
	 */
	public void performDbDelete() throws SQLException;

	/**
	 * insert the object as a new record into the database
	 * 
	 * @throws SQLException
	 *             if the query fails
	 */
	public void performDbInsert(int parentId) throws SQLException;

	/**
	 * return this object's name. The name should be unique but may be
	 * synthetic, for example the id of the object in the database
	 * 
	 * @return this object's name
	 */
	public String getName();
}
