/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.data;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * This class represents the code packages belonging to a study. It can only be
 * used with Study itself.
 * 
 * @author alve
 * 
 */

public class StudyPackages extends DbBackedProperties<StudyPackages.Package> {

	public final static String TABLE_NAME = "study_packages";

	/**
	 * Apart from a name and a local path to put it when simulating a package
	 * also has a version, so that it can be identified in the packages table
	 * 
	 * @author alve
	 * 
	 */
	public class Package extends DbBackedProperties.Property {

		protected String version;

		/**
		 * create a new package
		 * 
		 * @param name
		 * @param version
		 * @param localPath
		 */
		public Package(String name, String version, String localPath) {
			super(name, localPath);
			this.version = version;
		}

		public void performDbInsert(int studyId) throws SQLException {
			id = studyId;
			statement
					.execute("INSERT INTO " + TABLE_NAME + " VALUES ('" + id
							+ "', '" + value + "', '" + name + "', '" + version
							+ "');");
		}

		public void performDbDelete() throws SQLException {
			statement.execute("DELETE FROM " + TABLE_NAME + " WHERE studyId='"
					+ id + "' AND packageName='" + name
					+ "' AND packageVersion='" + version + "';");
		}

		public void performDbUpdate() throws SQLException {
			statement
					.execute("REPLACE INTO " + TABLE_NAME + " VALUES ('" + id
							+ "', '" + value + "', '" + name + "', '" + version
							+ "');");
		}

		public String getVersion() {
			return version;
		}
	}

	public StudyPackages(Connection definitions, int id) {
		super(definitions, id);
	}

	public StudyPackages(StudyPackages other) {
		super(other);
	}

	@Override
	public Package getEmptyDependent() {
		return new Package(null, null, null);
	}

	@Override
	public Package getDependent(ResultSet data) throws SQLException {
		return new Package(data.getString("packageName"), data
				.getString("packageVersion"), data.getString("localPath"));
	}

	@Override
	public Package getDependent(Package other) {
		return new Package(other.name, other.version, other.value);
	}

	@Override
	public void loadFromDb() throws SQLException {
		ResultSet params = statement.executeQuery("SELECT * FROM " + TABLE_NAME
				+ " WHERE studyId=" + id + " ORDER BY packageName;");
		super.loadFromDb(params);
	}

}
