/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.tableModels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;

import javax.swing.JTable;

import brn.distsim.client.data.DbBackedData;
import brn.distsim.client.ui.ClientFrame;


public abstract class AddRemoveTableModel<E extends DbBackedData> extends
		BaseTableModel implements ActionListener {

	protected List<String> names;

	protected E data;

	private static final long serialVersionUID = -7070362041897241214L;

	public AddRemoveTableModel(ClientFrame frame, E newData, JTable subject,
			List<String> names) {
		super(frame, subject);
		this.names = names;
		this.data = newData;
	}

	public void actionPerformed(ActionEvent arg0) {
		try {
			if (!examineAction(arg0)) {
				error("unrecognized action: " + arg0.getActionCommand());
			}
		} catch (Exception e) {
			error(e);
		}
	}

	public abstract int getColumnCount();

	public abstract int getRowCount();

	protected boolean examineAction(ActionEvent e) throws SQLException {
		String command = e.getActionCommand();
		int pos = getSelected();
		if (command.equals("remove")) {
			if (pos < 0)
				return true;
			remove(pos);
			fireTableStructureChanged();
			return true;
		} else if (command.equals("rollback")) {
			data.loadFromDb();
			readData();
			return true;
		} else if (command.equals("commit")) {
			data.commit();
			data.loadFromDb();
			readData();
			return true;
		} else if (command.equals("create")) {
			create();
			fireTableStructureChanged();
			return true;
		} else
			return false;
	}

	protected abstract void readData();
	
	protected abstract String create();

	protected abstract boolean remove(int pos);

	protected abstract int getSelected();

	protected abstract void setSelected(int pos);

	/*
	 * public void cloneColumn(int pos) {
	 * 
	 * SimulationGroup group; if (pos > 0) group =
	 * ((SimulationGroup)content.get(pos-1)).clone(); else group = new
	 * SimulationGroup();
	 * 
	 * String groupName = JOptionPane.showInputDialog("input group name");
	 * group.setName(groupName); content.add(group);
	 * 
	 * fireTableStructureChanged(); }
	 */
}
