/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.tableModels;

import java.awt.event.ActionListener;

import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

import brn.distsim.client.ui.ClientFrame;


public abstract class BaseTableModel extends AbstractTableModel implements
		ActionListener {

	protected ClientFrame frame;
	
	protected JTable subject;
	
	public BaseTableModel(ClientFrame frame, JTable subject) {
		this.frame = frame;
		this.subject = subject;
	}
	
	public void reconnectButton(AbstractButton button) {
		reconnectButton(button, this);
	}
	
	public static void reconnectButton(AbstractButton button, ActionListener listener) {
		ActionListener[] listeners = button.getActionListeners();
		for (int i = 0; i < listeners.length; ++i) {
			button.removeActionListener(listeners[i]);
		}
		button.addActionListener(listener);
	}
	
	public static void error(Exception e) {
		e.printStackTrace();
		JOptionPane.showMessageDialog(null, e.getMessage());
	}

	public static void error(String e) {
		JOptionPane.showMessageDialog(null, e);
	}

	public static boolean warn(String message) {
		String[] options = { "yes", "no" };
		int n = JOptionPane.showOptionDialog(null, message, "Warning",
				JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, null,
				options, options[0]);
		if (n == JOptionPane.YES_OPTION)
			return true;
		else
			return false;
	}
	
	public void switchTabs() {
		JTabbedPane workspace = frame.getWorkspacePane();
		workspace.setSelectedIndex(workspace.getSelectedIndex() + 1);
	}
	
}
