/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.tableModels;

import java.sql.SQLException;

import javax.swing.JOptionPane;
import javax.swing.JTable;

import brn.distsim.client.DBConnector;
import brn.distsim.client.data.GroupConfigurationFiles;
import brn.distsim.client.data.Study;
import brn.distsim.client.data.GroupConfigurationFiles.File;
import brn.distsim.client.ui.ClientFrame;


public class FileInTableModel extends FileTableModel {

	public FileInTableModel(ClientFrame parent, Study data, JTable subject) {
		super(parent, data, subject);
		//readData();
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = -3172371043672699417L;

	public String getColumnName(int col) {
		if (col == 0)
			return "Configuration Files";
		else
			return "local file";
	}

	@Override
	protected String create() {
		String name = JOptionPane.showInputDialog("path to file on simulating host");
		if (name != null) names.add(name);
		return name;
	}

	@Override
	protected boolean remove(int pos) {
		String name = names.get(pos);
		boolean success = true;
		for (int i = 0; i < data.size(); ++i) {
			if (data.isInserted(i))
				data.get(i).getConfigurationFiles().remove(name);
			else  if (data.get(i).getConfigurationFiles().get(name) != null)
				success = false;
		}
		if (success)
			names.remove(pos);
		return success;
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		String name = names.get(rowIndex);
		if (columnIndex == 0)
			return name;
		else {
			File file = data.get(columnIndex - 1).getConfigurationFiles().get(
					name);
			if (file == null)
				return null;
			String path = file.getValue();
			if (path != null)
				return path;
			else {
				return "in DB: " + file.getFileId();
			}
		}
	}

	public void setValueAt(Object value, int row, int col) {
		String name = names.get(row);
		GroupConfigurationFiles files = data.get(col - 1).getConfigurationFiles();
		files.put(files.new File(name, (String)value));
	}

	@Override
	public void readData() {
		try {
			names = GroupConfigurationFiles.getNames(DBConnector
					.getDefinitions(), data.getId());
		} catch (SQLException e) {
			error(e);
		}
	}

	

}
