/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.tableModels;

import java.sql.SQLException;

import javax.swing.JOptionPane;
import javax.swing.JTable;

import brn.distsim.client.DBConnector;
import brn.distsim.client.data.GroupResultsFiles;
import brn.distsim.client.data.Study;
import brn.distsim.client.data.GroupResultsFiles.File;
import brn.distsim.client.ui.ClientFrame;


public class FileOutTableModel extends FileTableModel {

	public FileOutTableModel(ClientFrame parent, Study data, JTable subject) {
		super(parent, data, subject);
		//readData();
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 3514599904828733950L;

	@Override
	protected String create() {
		String name = JOptionPane.showInputDialog("path to file on simulating host");
		if (name != null) names.add(name);
		return name;
	}

	public String getColumnName(int col) {
		if (col == 0)
			return "Results Files";
		else
			return "retrieve";
	}

	public Class<?> getColumnClass(int c) {
		if (c == 0)
			return String.class;
		else
			return Boolean.class;
	}

	@Override
	protected boolean remove(int pos) {
		String name = names.get(pos);
		boolean success = true;
		for (int i = 0; i < data.size(); ++i) {
			if (data.isInserted(pos))
				data.get(i).getResultsFiles().remove(name);
			else if (data.get(i).getResultsFiles().get(name) != null)
				success = false;
		}
		if (success)
			names.remove(pos);
		return success;
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		String name = names.get(rowIndex);
		if (columnIndex == 0)
			return name;
		else {
			File file = data.get(columnIndex - 1).getResultsFiles().get(name);
			if (file == null)
				return false;
			else
				return true;
		}
	}
	
	public void setValueAt(Object value, int row, int col) {
		String name = names.get(row);
		GroupResultsFiles files = data.get(col - 1).getResultsFiles(); 
		if (((Boolean)value).booleanValue()) {
			files.add(name);
		} else {
			files.remove(name);
		}
	}

	@Override
	public void readData() {
		try {
			names = GroupResultsFiles.getNames(DBConnector
					.getDefinitions(), data.getId());
		} catch (SQLException e) {
			error(e);
		}
	}

}
