/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.tableModels;

import java.util.ArrayList;

import javax.swing.JTable;

import brn.distsim.client.data.Study;
import brn.distsim.client.ui.ClientFrame;


public abstract class FileTableModel extends AddRemoveTableModel<Study> {

	public FileTableModel(ClientFrame parent, Study data, JTable subject) {
		super(parent, data, subject, new ArrayList<String>());
	}

	public int getColumnCount() {
		return data.size() + 1;
	}

	public int getRowCount() {
		return names.size();
	}
	
	@Override
	protected int getSelected() {
		return subject.getSelectedRow();
	}

	@Override
	public void setSelected(int pos) {
		subject.setRowSelectionInterval(pos, pos);
	}
	
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		if (columnIndex > 0 && data.isInserted(columnIndex - 1))
			return true;
		else
			return false;
	}
}
