/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.tableModels;

import java.sql.SQLException;

import javax.swing.JTable;

import brn.distsim.client.DBConnector;
import brn.distsim.client.data.Study;
import brn.distsim.client.data.StudyPackages;
import brn.distsim.client.data.StudyPackages.Package;
import brn.distsim.client.ui.AddRemoveToolBar;
import brn.distsim.client.ui.ClientFrame;
import brn.distsim.client.ui.PackageChooseDialog;


public class PackagesTableModel extends
		EditableTableModel<StudyPackages, StudyPackages.Package> {

	private StudyPackages dummy;

	private PackageDefinition definition;

	public PackagesTableModel(ClientFrame frame, JTable subject) {
		super(frame, null, subject);
		definition = new PackageDefinition();
		dummy = new StudyPackages(DBConnector.getDefinitions(), 0);
		data = dummy;
		AddRemoveToolBar t = frame.getStudyPanel().getPackagesToolBar();
		reconnectButton(t.getAddButton());
		t.getAddButton().setEnabled(false);
		reconnectButton(t.getRemoveButton());
		t.getRemoveButton().setEnabled(false);
		reconnectButton(frame.getStudyPanel().getDefinePackagesButton(),
				definition);
		subject.setModel(this);
	}

	private static final long serialVersionUID = -6797410586312257505L;

	public String getColumnName(int col) {
		switch (col) {
		case 0:
			return "name";
		case 1:
			return "version";
		case 2:
			return "path";
		default:
			return null;
		}
	}

	public void configure(Study study, boolean editable) {
		data = study.getPackages();
		for (int i = 0; i < data.size(); ++i) {
			names.add(data.get(i).getName());
		}
		AddRemoveToolBar t = frame.getStudyPanel().getPackagesToolBar();
		if (editable) {
			t.getAddButton().setEnabled(true);
			t.getRemoveButton().setEnabled(true);
		} else {
			t.getAddButton().setEnabled(false);
			t.getRemoveButton().setEnabled(false);
		}
		fireTableStructureChanged();
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		StudyPackages.Package d = data.get(rowIndex);
		switch (columnIndex) {
		case 0:
			return d.getName();
		case 1:
			return d.getVersion();
		case 2:
			return d.getValue();
		}
		return null;
	}

	public void clear() {
		data = dummy;
		names.clear();
		fireTableStructureChanged();
	}

	@Override
	public int getColumnCount() {
		return 3;
	}

	@Override
	protected void readData() {
		// TODO Automatisch erstellter Methoden-Stub

	}

	public boolean isCellEditable(int rowIndex, int columnIndex) {
		if (columnIndex == 2 && data.isInserted(rowIndex))
			return true;
		else
			return false;
	}

	@Override
	protected void connect(Package newData) {
		// nothing to do
	}

	@Override
	protected Package createData() {
		if (data == dummy)
			return null;
		try {
			PackageChooseDialog d = new PackageChooseDialog(brn.distsim.client.data.Package
					.getAllVersions(DBConnector.getDefinitions()));
			String name = d.getName();
			Package p = null;
			if (name != null)
				p = data.new Package(name, d.getVersion(), "");
			return p;
		} catch (SQLException e) {
			error(e);
			return null;
		}
	}

	@Override
	protected Package cloneData(Package orig) {
		return data.new Package(orig.getName(), orig.getVersion(), orig.getValue());
	}

	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
		String name = data.get(rowIndex).getName();
		String version = data.get(rowIndex).getVersion();
		String path = (String) aValue;
		data.set(rowIndex, data.new Package(name, version, path));
	}

}
