/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.tableModels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import javax.swing.JComboBox;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import brn.distsim.client.data.Results;
import brn.distsim.client.ui.ClientFrame;
import brn.distsim.client.ui.ResultsPanel;


public class ResultsModel extends BaseTableModel implements ActionListener,
		ListSelectionListener {

	private static final long serialVersionUID = 4553022244080010403L;

	private ResultsPanel subject;

	private Results data;

	private List<String> childTables;

	private Map<Integer, Integer> columnKeys;

	public ResultsModel(ClientFrame frame, Results data) {
		super(frame, null);
		this.data = data;
		subject = frame.getResultsPanel();
		childTables = new LinkedList<String>();
		columnKeys = new HashMap<Integer, Integer>();
		//reconnectButton(subject.getFocusButton());
		reconnectButton(subject.getReloadButton());
		JComboBox box = subject.getTableChooser();

		// stupid workaround for the fact that JComboBox and JButton don't have
		// a useful common ancestor
		ActionListener[] listeners = box.getActionListeners();
		for (int i = 0; i < listeners.length; ++i) {
			box.removeActionListener(listeners[i]);
		}
		box.addActionListener(this);
		fillTableChooser();
	}

	private void fillTableChooser() {
		try {
			JComboBox chooser = subject.getTableChooser();
			chooser.removeAllItems();
			for (String name : data.getTableNames()) {
				chooser.addItem(name);
			}
		} catch (SQLException e) {
			error(e);
		}
	}

	public void actionPerformed(ActionEvent e) {
		try {
			String command = e.getActionCommand();
			if (command.equals("reload")) {
				fillTableChooser();
				subject.clearTables();
			} else if (command.equals("select")) {
				String name = (String) subject.getTableChooser()
						.getSelectedItem();
				childTables.clear();
				if (name != null) {
					childTables.addAll(data.getChildTableNames(name));
					subject.clearTables();
					Vector<Vector<String>> subClassData = data.getData(name);
					for (int row = 0; row < subClassData.size(); ++row) {
						columnKeys.put(row, Integer.valueOf(subClassData.get(
								row).get(0)));
					}
					subject.addParentTable(name, data.getColumnNames(name),
							subClassData).getSelectionModel()
							.addListSelectionListener(this);
					String subName = data.getSuperclass(name);
					while (subName != null) {
						childTables.addAll(data.getChildTableNames(subName));
						subject.addParentTable(subName,
								data.getSubTableColumnNames(subName),
								data.getSuperClassData(subName, name))
								.getSelectionModel().addListSelectionListener(
										this);
						subName = data.getSuperclass(subName);
					}
				}
			}
		} catch (SQLException ex) {
			error(ex);
		}
	}

	public void valueChanged(ListSelectionEvent e) {
		try {
			// Ignore extra messages.
			if (e.getValueIsAdjusting())
				return;

			ListSelectionModel lsm = (ListSelectionModel) e.getSource();
			if (!lsm.isSelectionEmpty()) {
				int selectedRow = lsm.getMinSelectionIndex();
				subject.clearChildTables();
				for (String tName : childTables) {
					subject.addChildTable(tName, data
							.getSubTableColumnNames(tName), data.getChildData(
							tName, columnKeys.get(selectedRow)));
				}
			}
		} catch (SQLException ex) {
			error(ex);
		}
	}

	public int getRowCount() {
		return 0;
	}

	public int getColumnCount() {
		return 0;
	}

	public Object getValueAt(int rowIndex, int columnIndex) {
		return null;
	}

}
