/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public class AddRemoveToolBar extends JToolBar {

	/**
	 * 
	 */
	private static final long serialVersionUID = 3L;

	private JButton addButton;

	private JButton removeButton;

	public AddRemoveToolBar(String name, String shortName) {
		add(new JLabel(name));
		addButton = new JButton(new ImageIcon(ClassLoader
				.getSystemResource("toolbarButtonGraphics/general/Add24.gif")));
		addButton.setActionCommand("create");
		addButton.setToolTipText("add " + shortName);
		add(addButton);
		removeButton = new JButton(new ImageIcon(ClassLoader
				.getSystemResource("toolbarButtonGraphics/general/Delete24.gif")));
		removeButton.setActionCommand("remove");
		removeButton.setToolTipText("delete " + shortName);
		add(removeButton);

	}

	public JButton getAddButton() {
		return addButton;
	}

	public JButton getRemoveButton() {
		return removeButton;
	}

}
