/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public abstract class CellRenderer<C extends JComponent> implements
		TableCellRenderer {

	protected C content;

	public CellRenderer(C content) {
		this.content = content;
		content.setOpaque(true);
	}

	public void paintCell(JTable table, int row, int column) {
		boolean cfits = (table.getSelectedColumn() == column);
		boolean rfits = (table.getSelectedRow() == row);
		if (column == 0) {
			content.setBackground(UIManager.getColor("TableHeader.background"));
			content.setForeground(UIManager.getColor("TableHeader.foreground"));
			content.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
			if (row == 0) 
				table.setRowHeight(table.getTableHeader().getPreferredSize().height);
		} else if (cfits || rfits) {
			content.setBackground(UIManager
					.getColor("Table.selectionBackground"));
			content.setForeground(UIManager
					.getColor("Table.selectionForeground"));
			if (cfits && rfits)
				content.setBorder(UIManager
						.getBorder("Table.focusCellHighlightBorder"));
			else
				content.setBorder(null);
		} else {
			content.setBackground(UIManager.getColor("Table.background"));
			content.setForeground(UIManager.getColor("Table.foreground"));
			content.setBorder(null);
		}
	}

}
