/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import java.awt.Component;

import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;

public class CheckBoxCellRenderer extends CellRenderer<JCheckBox> {

	/*
	 * private JLabel columnLabel;
	 * 
	 * public CheckBoxCellRenderer() { super(new JCheckBox()); columnLabel = new
	 * JLabel();
	 * columnLabel.setBackground(UIManager.getColor("Label.background")); }
	 * 
	 * public Component getTableCellRendererComponent(JTable table, Object
	 * value, boolean isSelected, boolean hasFocus, int row, int column) { if
	 * (column == 0) { columnLabel.setText((String) value); return columnLabel; }
	 * else { content.setSelected(((Boolean) value).booleanValue());
	 * super.paintCell(table, row, column); return content; } }
	 */
	//private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

	public CheckBoxCellRenderer() {
		super(new JCheckBox());
		content.setHorizontalAlignment(JLabel.CENTER);
		// content.setBorderPainted(true);
	}

	public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column) {
		paintCell(table, row, column);
		content
				.setSelected((value != null && ((Boolean) value).booleanValue()));

		return content;
	}

}
