/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class ClientFrame extends JFrame {

	private static final long serialVersionUID = 4218321151630046918L;

	private JTabbedPane workspacePane = null;

	private DBPanel dbPanel = null;

	private StudyPanel studyPanel = null;

	private SimulationPanel simulationPanel = null;

	private MonitorPanel monitorPanel = null;

	private ResultsPanel resultsPanel = null;

	/**
	 * This is the default constructor
	 */
	public ClientFrame() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 *
	 */
	private void initialize() {
		this.setContentPane(getWorkspacePane());
		this.setTitle("Simulation Client");
		this.setDefaultCloseOperation(EXIT_ON_CLOSE);
	}



	/**
	 * This method initializes workspacePane
	 *
	 * @return javax.swing.JTabbedPane
	 */
	public JTabbedPane getWorkspacePane() {
		if (workspacePane == null) {
			workspacePane = new JTabbedPane();
			workspacePane.addTab("database connection", null, getDbPanel(),
					null);
			workspacePane
					.addTab("simulation type", null, getStudyPanel(), null);
			workspacePane.addTab("parameter definition", null,
					getSimulationPanel(), null);
			workspacePane.addTab("execution monitor", null, getMonitorPanel(),
					null);
			workspacePane.addTab("results", null, getResultsPanel(), null);
		}
		return workspacePane;
	}

	/**
	 * This method initializes dbPanel
	 *
	 * @return javax.swing.JPanel
	 */
	public DBPanel getDbPanel() {
		if (dbPanel == null) {
			dbPanel = new DBPanel();
		}
		return dbPanel;
	}

	/**
	 * This method initializes typePanel
	 *
	 * @return javax.swing.JPanel
	 */
	public StudyPanel getStudyPanel() {
		if (studyPanel == null) {
			studyPanel = new StudyPanel();
		}
		return studyPanel;
	}

	/**
	 * This method initializes simulationPanel
	 *
	 * @return javax.swing.JPanel
	 */
	public SimulationPanel getSimulationPanel() {
		if (simulationPanel == null) {
			simulationPanel = new SimulationPanel();
		}
		return simulationPanel;
	}

	/**
	 * This method initializes monitorPanel
	 *
	 * @return javax.swing.JPanel
	 */
	public MonitorPanel getMonitorPanel() {
		if (monitorPanel == null) {
			monitorPanel = new MonitorPanel();
		}
		return monitorPanel;
	}

	/**
	 * This method initializes resultsPanel
	 *
	 * @return javax.swing.JPanel
	 */
	public ResultsPanel getResultsPanel() {
		if (resultsPanel == null) {
			resultsPanel = new ResultsPanel();
		}
		return resultsPanel;
	}

} // @jve:decl-index=0:visual-constraint="10,10"
