/*
 * This file is part of the DistSim distributed simulation framework (client)
 * Copyright (C) 2007 Ulf Hermann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package brn.distsim.client.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DBPanel extends JPanel {

	private static final long serialVersionUID = 1L;
	private JLabel defLabel = null;

	private JLabel resLabel = null;

	private JTextField defUserTextField = null;

	private JTextField resUserTextField = null;

	private JLabel userLabel = null;

	private JTextField resHostTextField = null;

	private JTextField defHostTextField = null;

	private JLabel hostLabel = null;

	private JTextField resDbTextField = null;

	private JTextField defDbTextField = null;

	private JLabel dbLabel = null;

	private JPasswordField resPasswordField = null;

	private JPasswordField defPasswordField = null;

	private JLabel passwordLabel = null;

	private JButton connectButton = null;

	private static final int textWidth = 24;

	/**
	 * This is the default constructor
	 */
	public DBPanel() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 */
	private void initialize() {
		this.setLayout(new GridBagLayout());
		passwordLabel = new JLabel();
		passwordLabel.setText(" password: ");

		dbLabel = new JLabel();
		dbLabel.setText(" database name: ");

		hostLabel = new JLabel();
		hostLabel.setText(" database server: ");

		userLabel = new JLabel();
		userLabel.setText(" user name: ");

		resLabel = new JLabel();
		resLabel.setText(" results: ");

		defLabel = new JLabel();
		defLabel.setText(" definitions: ");

		GridBagConstraints lastColumn = new GridBagConstraints();
		lastColumn.gridwidth = GridBagConstraints.REMAINDER;

		GridBagConstraints padding = new GridBagConstraints();
		padding.insets = new Insets(10,10,10,10);

		JLabel nullLabel = new JLabel(" ");

		this.add(nullLabel);
		this.add(defLabel, padding);
		this.add(resLabel, lastColumn);

		this.add(hostLabel, padding);
		this.add(getDefHostTextField(), padding);
		this.add(getResHostTextField(), lastColumn);

		this.add(dbLabel, padding);
		this.add(getDefDbTextField(), padding);
		this.add(getResDbTextField(), lastColumn);

		this.add(userLabel, padding);
		this.add(getDefUserTextField(), padding);
		this.add(getResUserTextField(), lastColumn);

		this.add(passwordLabel, padding);
		this.add(getDefPasswordField(), padding);
		this.add(getResPasswordField(), lastColumn);

		this.add(new JLabel(" "), padding);
		this.add(getConnectButton(), lastColumn);
	}

	/**
	 * This method initializes defUserTextField
	 *
	 * @return javax.swing.JTextField
	 */
	public JTextField getDefUserTextField() {
		if (defUserTextField == null) {
			defUserTextField = new JTextField(textWidth);
			defUserTextField.setText("alve");
		}
		return defUserTextField;
	}

	/**
	 * This method initializes resUserTextField
	 *
	 * @return javax.swing.JTextField
	 */
	public JTextField getResUserTextField() {
		if (resUserTextField == null) {
			resUserTextField = new JTextField(textWidth);
			resUserTextField.setText("alve");
		}
		return resUserTextField;
	}

	/**
	 * This method initializes resHostTextField
	 *
	 * @return javax.swing.JTextField
	 */
	public JTextField getResHostTextField() {
		if (resHostTextField == null) {
			resHostTextField = new JTextField(textWidth);
			resHostTextField.setText("localhost");
		}
		return resHostTextField;
	}

	/**
	 * This method initializes defHostTextField
	 *
	 * @return javax.swing.JTextField
	 */
	public JTextField getDefHostTextField() {
		if (defHostTextField == null) {
			defHostTextField = new JTextField(textWidth);
			defHostTextField.setText("localhost");
		}
		return defHostTextField;
	}

	/**
	 * This method initializes resDbTextField
	 *
	 * @return javax.swing.JTextField
	 */
	public JTextField getResDbTextField() {
		if (resDbTextField == null) {
			resDbTextField = new JTextField(textWidth);
			resDbTextField.setText("simulation_results");
		}
		return resDbTextField;
	}

	/**
	 * This method initializes defDbTextField
	 *
	 * @return javax.swing.JTextField
	 */
	public JTextField getDefDbTextField() {
		if (defDbTextField == null) {
			defDbTextField = new JTextField(textWidth);
			defDbTextField.setText("simulation");
		}
		return defDbTextField;
	}

	/**
	 * This method initializes resPasswordField
	 *
	 * @return javax.swing.JPasswordField
	 */
	public JPasswordField getResPasswordField() {
		if (resPasswordField == null) {
			resPasswordField = new JPasswordField(textWidth);
			resPasswordField.setText("hannes");
		}
		return resPasswordField;
	}

	/**
	 * This method initializes defPasswordField
	 *
	 * @return javax.swing.JPasswordField
	 */
	public JPasswordField getDefPasswordField() {
		if (defPasswordField == null) {
			defPasswordField = new JPasswordField(textWidth);
			defPasswordField.setText("hannes");
		}
		return defPasswordField;
	}

	/**
	 * This method initializes connectButton
	 *
	 * @return javax.swing.JButton
	 */
	public JButton getConnectButton() {
		if (connectButton == null) {
			connectButton = new JButton();
			connectButton.setText("connect");
		}
		return connectButton;
	}






}  //  @jve:decl-index=0:visual-constraint="10,10"
